/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusCredentials;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client.CredentialUtilities;
import java.security.PrivateKey;

public class BasicAltusCredentials
implements AltusCredentials {
    private final String accessKeyId;
    private final PrivateKey privateKey;

    public BasicAltusCredentials(String accessKeyId, String privateKey) {
        this(accessKeyId, CredentialUtilities.decodePrivateKey(ValidationUtils.checkNotNullAndThrow(privateKey)));
    }

    public BasicAltusCredentials(String accessKeyId, PrivateKey privateKey) {
        ValidationUtils.checkNotNullAndThrow(accessKeyId);
        ValidationUtils.checkNotNullAndThrow(privateKey);
        this.accessKeyId = accessKeyId;
        this.privateKey = privateKey;
    }

    @Override
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

