/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusClientException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusServiceException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.annotation.SdkInternalApi;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client.AltusClientConfiguration;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.databind.util.StdDateFormat;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.base.Strings;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.ws.rs.client.Client;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.ws.rs.client.ClientBuilder;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.ws.rs.client.Entity;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.ws.rs.client.Invocation;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.ws.rs.core.Response;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.glassfish.jersey.client.ClientConfig;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

@SdkInternalApi
class ClientConnectionWrapper
implements AutoCloseable {
    private static final KeyStore USE_DEFAULT_KEYSTORE = null;
    private final AltusClientConfiguration altusClientConfiguration;
    private final Client httpClient;

    ClientConnectionWrapper(AltusClientConfiguration altusClientConfiguration) {
        SSLContext sslContext;
        this.altusClientConfiguration = ValidationUtils.checkNotNullAndThrow(altusClientConfiguration);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.setDateFormat(new StdDateFormat());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider(objectMapper);
        ClientConfig config = new ClientConfig();
        config.register(jsonProvider);
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(USE_DEFAULT_KEYSTORE);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new AltusClientException("Error initializing truststore", e);
        }
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new AltusClientException("Error initializing SSL", e);
        }
        DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
        this.httpClient = ClientBuilder.newBuilder().withConfig(config).hostnameVerifier(hostnameVerifier).sslContext(sslContext).build();
        this.httpClient.property("jersey.config.client.readTimeout", (int)altusClientConfiguration.getReadTimeout().toMillis());
        this.httpClient.property("jersey.config.client.connectTimeout", (int)altusClientConfiguration.getConnectionTimeout().toMillis());
    }

    Response doPost(String endPoint, String path, String auth, String date, Object requestBody) throws AltusServiceException {
        String altusClientApp = this.altusClientConfiguration.getClientApplicationName();
        Invocation.Builder builder = this.httpClient.target(endPoint + path).request().accept("application/json").header("x-altus-date", date).header("x-altus-auth", auth).header("content-type", "application/json");
        if (!Strings.isNullOrEmpty(altusClientApp)) {
            builder.header("x-altus-client-app", altusClientApp);
        }
        return builder.post(Entity.entity(requestBody, "application/json"));
    }

    @Override
    public void close() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }
}

