/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.client;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusClientException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.util.io.pem.PemObject;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.bouncycastle.util.io.pem.PemReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import net.i2p.crypto.eddsa.EdDSASecurityProvider;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;

public class CredentialUtilities {
    private static final int ED25519_KEY_LENGTH = 44;
    private static final EdDSANamedCurveSpec ED25519 = EdDSANamedCurveTable.getByName("Ed25519");

    private CredentialUtilities() {
    }

    public static PrivateKey decodePrivateKey(String privateKey) {
        ValidationUtils.checkNotNullAndThrow(privateKey);
        if (privateKey.length() == 44) {
            return CredentialUtilities.decodeEd25519PrivateKey(privateKey);
        }
        return CredentialUtilities.decodeRSAPrivateKey(privateKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PrivateKey decodeRSAPrivateKey(String privateKey) {
        privateKey = privateKey.replace("\\n", "\n");
        try (PemReader pemReader = new PemReader(new StringReader(privateKey));){
            PemObject pemObject = pemReader.readPemObject();
            if (pemObject == null) {
                throw new AltusClientException("Invalid private key ");
            }
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey2 = factory.generatePrivate(privateKeySpec);
            return privateKey2;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AltusClientException("Unable to generate private key " + e.getMessage(), e);
        }
    }

    private static PrivateKey decodeEd25519PrivateKey(String privateKey) {
        Security.addProvider(new EdDSASecurityProvider());
        byte[] seed = Base64.getDecoder().decode(privateKey);
        try {
            EdDSAPrivateKeySpec privateKeySpec = new EdDSAPrivateKeySpec(seed, ED25519);
            KeyFactory factory = KeyFactory.getInstance("EdDSA");
            return factory.generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AltusClientException("Unable to generate private key " + e.getMessage(), e);
        }
    }
}

