/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http.DelayPolicy;
import java.time.Duration;

public class ExponentialBackoffDelayPolicy
implements DelayPolicy {
    private final int growthFactor;
    private final Duration base;

    public ExponentialBackoffDelayPolicy(int growthFactor, Duration base) {
        ValidationUtils.checkArgumentAndThrow(growthFactor > 0);
        ValidationUtils.checkNotNullAndThrow(base);
        ValidationUtils.checkArgumentAndThrow(base.toMillis() > 0L);
        this.growthFactor = growthFactor;
        this.base = base;
    }

    @Override
    public Duration delay(int attempts) {
        ValidationUtils.checkArgumentAndThrow(attempts >= 1);
        return Duration.ofMillis((long)((double)this.base.toMillis() * Math.pow(this.growthFactor, attempts - 1)));
    }
}

