/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusClientException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusHTTPException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.http.RetryChecker;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.collect.ImmutableSet;
import java.util.Set;

public class HttpCodesRetryChecker
implements RetryChecker {
    public static final ImmutableSet<Integer> DEFAULT_RETRY_CODES = ImmutableSet.of(Integer.valueOf(503), Integer.valueOf(429));
    private final ImmutableSet<Integer> retriableCodes;

    public HttpCodesRetryChecker(Set<Integer> httpCodes) {
        ValidationUtils.checkNotNullAndThrow(httpCodes);
        ValidationUtils.checkArgumentAndThrow(httpCodes.size() > 0);
        this.retriableCodes = ImmutableSet.copyOf(httpCodes);
    }

    @Override
    public boolean shouldRetry(int attempts, AltusClientException exception) {
        ValidationUtils.checkNotNullAndThrow(exception);
        ValidationUtils.checkArgumentAndThrow(attempts >= 1);
        if (exception instanceof AltusHTTPException) {
            return this.retriableCodes.contains(((AltusHTTPException)exception).getHttpCode());
        }
        return false;
    }
}

