/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.aeprocessor.aebuilder.value;

import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.value.AEScalarFnMetadataFactory;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.ScalarFunctionID;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AECustomScalarFn;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.impala.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.cloudera.impala.sqlengine.dsiext.dataengine.CustomScalarFunction;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.impala.sqlengine.parser.parsetree.PTIdentifierNode;
import com.cloudera.impala.sqlengine.parser.parsetree.PTListNode;
import com.cloudera.impala.sqlengine.parser.parsetree.PTLiteralNode;
import com.cloudera.impala.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.impala.sqlengine.parser.type.PTListType;
import com.cloudera.impala.sqlengine.parser.type.PTLiteralType;
import com.cloudera.impala.sqlengine.parser.type.PTNonterminalType;
import com.cloudera.impala.sqlengine.parser.type.PTPositionalType;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class AEScalarFnBuilder
extends AEBuilderBase<AEValueExpr> {
    private static final Map<String, Map<Integer, ScalarFunctionID>> SCALAR_FN_LOOKUP;
    private SqlDataEngine m_dataEngine;

    protected AEScalarFnBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
        this.m_dataEngine = aEQueryScope.getDataEngine();
    }

    @Override
    public AEValueExpr visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.FUNC)).withExactChildren(PTPositionalType.NAME, AEBuilderCheck.identifier(), PTPositionalType.PARAM_LIST, AEBuilderCheck.optionalList(PTListType.PARAMETER_LIST)));
        String string = ((PTIdentifierNode)pTNonterminalNode.getChild(PTPositionalType.NAME)).getIdentifier();
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.PARAM_LIST);
        PTListNode pTListNode = iPTNode.isEmptyNode() ? new PTListNode(PTListType.PARAMETER_LIST) : (PTListNode)iPTNode;
        CustomScalarFunction customScalarFunction = this.m_dataEngine.openScalarFunction(string, pTListNode.numChildren());
        if (null != customScalarFunction) {
            return this.buildCustomScalarFn(pTListNode, customScalarFunction);
        }
        Map<Integer, ScalarFunctionID> map = SCALAR_FN_LOOKUP.get(string);
        if (null == map) {
            throw SQLEngineExceptionFactory.invalidScalarFnNameException(string);
        }
        ScalarFunctionID scalarFunctionID = map.get(pTListNode.numChildren());
        if (null == scalarFunctionID) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
        }
        return this.buildScalarFn(string, scalarFunctionID, pTListNode);
    }

    private AECustomScalarFn buildCustomScalarFn(PTListNode pTListNode, CustomScalarFunction customScalarFunction) throws ErrorException {
        AEValueExprList aEValueExprList = new AEValueExprList();
        if (0 < pTListNode.numChildren()) {
            AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(this.getQueryScope());
            for (IPTNode iPTNode : pTListNode.getImmutableChildList()) {
                aEValueExprList.addNode(aEValueExprBuilder.build(iPTNode));
            }
        }
        return new AECustomScalarFn(customScalarFunction, aEValueExprList);
    }

    private AEScalarFn buildScalarFn(String string, ScalarFunctionID scalarFunctionID, PTListNode pTListNode) throws ErrorException {
        Iterator iterator;
        Object object2;
        Object object3;
        ArrayList<AECoercionColumnInfo> arrayList;
        AEValueExprList aEValueExprList;
        block15: {
            block14: {
                aEValueExprList = new AEValueExprList();
                arrayList = new ArrayList<AECoercionColumnInfo>();
                if (ScalarFunctionID.CONVERT2 != scalarFunctionID && ScalarFunctionID.CAST2 != scalarFunctionID && ScalarFunctionID.CONVERT3 != scalarFunctionID && ScalarFunctionID.CAST3 != scalarFunctionID && ScalarFunctionID.CONVERT4 != scalarFunctionID && ScalarFunctionID.CAST4 != scalarFunctionID) break block14;
                if (pTListNode.numChildren() > 4) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                object3 = new AEValueExprBuilder(this.getQueryScope());
                object2 = (AEValueExpr)((AEBuilderBase)object3).build(pTListNode.getChild(0));
                aEValueExprList.addNode(object2);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object2));
                IPTNode object4 = pTListNode.getChild(1);
                if (object4 instanceof PTLiteralNode) {
                    object2 = (AEValueExpr)((AEBuilderBase)object3).build(object4);
                } else if (object4 instanceof PTIdentifierNode) {
                    object2 = (AEValueExpr)((AEBuilderBase)object3).build(new PTLiteralNode(PTLiteralType.CHARSTR, ((PTIdentifierNode)object4).getIdentifier()));
                } else if (object4 instanceof PTNonterminalNode && PTNonterminalType.COLUMN_REFERENCE == ((PTNonterminalNode)object4).getNonterminalType()) {
                    iterator = (PTNonterminalNode)object4;
                    object2 = (AEValueExpr)((AEBuilderBase)object3).build(new PTLiteralNode(PTLiteralType.CHARSTR, ((PTIdentifierNode)((PTNonterminalNode)((Object)iterator)).getChild(PTPositionalType.COLUMN_NAME)).getIdentifier()));
                } else {
                    throw ScalarFunctionID.CONVERT2 == scalarFunctionID || ScalarFunctionID.CONVERT3 == scalarFunctionID || ScalarFunctionID.CONVERT4 == scalarFunctionID ? SQLEngineExceptionFactory.invalidSecondArgumentToConvertException() : SQLEngineExceptionFactory.invalidSecondArgumentToCastException();
                }
                aEValueExprList.addNode(object2);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object2));
                if (pTListNode.numChildren() < 3) break block15;
                object2 = (AEValueExpr)((AEBuilderBase)object3).build(pTListNode.getChild(2));
                aEValueExprList.addNode(object2);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object2));
                short s = Short.parseShort(((AECoercionColumnInfo)arrayList.get(2)).getLiteralString());
                if (s < 0) {
                    SQLEngineExceptionFactory.invalidScalarFunctionDataException(string, 3);
                }
                if (pTListNode.numChildren() != 4) break block15;
                object2 = (AEValueExpr)((AEBuilderBase)object3).build(pTListNode.getChild(3));
                aEValueExprList.addNode(object2);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object2));
                short s2 = Short.parseShort(((AECoercionColumnInfo)arrayList.get(3)).getLiteralString());
                if (s2 >= 0) break block15;
                SQLEngineExceptionFactory.invalidScalarFunctionDataException(string, 4);
                break block15;
            }
            if (ScalarFunctionID.USER == scalarFunctionID || ScalarFunctionID.DATABASE == scalarFunctionID) {
                assert (0 == pTListNode.numChildren());
                object3 = this.getQueryScope().getDataEngine().getContext();
                object2 = ScalarFunctionID.USER == scalarFunctionID ? ((SqlDataEngineContext)object3).getConnProperty(139).getString() : ((SqlDataEngineContext)object3).getConnProperty(22).getString();
                AELiteral aELiteral = new AELiteral((String)object2, PTLiteralType.CHARSTR, false, (SqlDataEngineContext)object3);
                aELiteral.setParent(aEValueExprList);
                aEValueExprList.addNode(aELiteral);
                arrayList.add(new AECoercionColumnInfo(aELiteral));
            } else if (0 < pTListNode.numChildren()) {
                object3 = new AEValueExprBuilder(this.getQueryScope());
                for (IPTNode iPTNode : pTListNode.getImmutableChildList()) {
                    iterator = (AEValueExpr)((AEBuilderBase)object3).build(iPTNode);
                    aEValueExprList.addNode(iterator);
                    arrayList.add(new AECoercionColumnInfo((AEValueExpr)((Object)iterator)));
                }
            }
        }
        object3 = AEScalarFnMetadataFactory.getInstance();
        object2 = ((AEScalarFnMetadataFactory)object3).createMetadata(this.m_dataEngine.getContext(), scalarFunctionID, string, arrayList);
        AEScalarFn aEScalarFn = new AEScalarFn(string, scalarFunctionID, ((AEScalarFnMetadataFactory.ScalarFnMetadata)object2).getColumnMetadata(), aEValueExprList, ((AEScalarFnMetadataFactory.ScalarFnMetadata)object2).getExpectedArgumentMetadata(), (AEScalarFnMetadataFactory)object3, this.m_dataEngine.getContext());
        arrayList.clear();
        iterator = aEScalarFn.getArguments().getChildItr();
        while (iterator.hasNext()) {
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)iterator.next()));
        }
        ((AEScalarFnMetadataFactory)object3).validateMetadata(this.m_dataEngine.getContext(), scalarFunctionID, string, arrayList);
        return aEScalarFn;
    }

    static {
        TreeMap<String, Map<Integer, ScalarFunctionID>> treeMap = new TreeMap<String, Map<Integer, ScalarFunctionID>>(String.CASE_INSENSITIVE_ORDER);
        for (ScalarFunctionID scalarFunctionID : ScalarFunctionID.values()) {
            Map<Integer, ScalarFunctionID> map = treeMap.get(scalarFunctionID.getName());
            if (null == map) {
                map = new HashMap<Integer, ScalarFunctionID>();
                treeMap.put(scalarFunctionID.getName(), map);
            }
            map.put(scalarFunctionID.getArguments().size(), scalarFunctionID);
        }
        SCALAR_FN_LOOKUP = treeMap;
    }
}

