/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.aeprocessor.aeoptimizer;

import com.cloudera.impala.sqlengine.aeprocessor.aeoptimizer.AEPassdownFilter;
import com.cloudera.impala.sqlengine.aeprocessor.aeoptimizer.AERelationalExprHandler;
import com.cloudera.impala.sqlengine.aeprocessor.aeoptimizer.IAEOptimizer;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.impala.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.impala.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.cloudera.impala.sqlengine.dsiext.dataengine.IBooleanExprHandler;
import com.cloudera.impala.support.Pair;
import com.cloudera.impala.support.exceptions.ErrorException;

public class AEPassdownOpOptimizer
implements IAEOptimizer {
    DSIExtOperationHandlerFactory m_opHandlerFactory;

    public AEPassdownOpOptimizer(DSIExtOperationHandlerFactory dSIExtOperationHandlerFactory) {
        this.m_opHandlerFactory = dSIExtOperationHandlerFactory;
    }

    @Override
    public void optimize(IAEStatement iAEStatement) throws ErrorException {
        if (iAEStatement instanceof AEQuery) {
            AEQuery aEQuery = (AEQuery)iAEStatement;
            aEQuery.setOperand(new AERelationalExprHandler(this.m_opHandlerFactory).passdown(aEQuery.getOperand()));
        } else if (iAEStatement instanceof AEUpdate) {
            AEUpdate aEUpdate = (AEUpdate)iAEStatement;
            AEBooleanExpr aEBooleanExpr = aEUpdate.getUpdateCondition();
            AETable aETable = aEUpdate.getTable();
            Pair<AETable, AEBooleanExpr> pair = this.doPassdown(aETable, aEBooleanExpr);
            aEUpdate.setTable(pair.key());
            aEUpdate.setUpdateCondition(pair.value());
        } else if (iAEStatement instanceof AEDelete) {
            AEDelete aEDelete = (AEDelete)iAEStatement;
            AEBooleanExpr aEBooleanExpr = aEDelete.getCondition();
            AETable aETable = aEDelete.getTable();
            Pair<AETable, AEBooleanExpr> pair = this.doPassdown(aETable, aEBooleanExpr);
            aEDelete.setTable(pair.key());
            aEDelete.setCondition(pair.value());
        }
    }

    private Pair<AETable, AEBooleanExpr> doPassdown(AETable aETable, AEBooleanExpr aEBooleanExpr) throws ErrorException {
        assert (aETable != null);
        assert (aEBooleanExpr != null);
        if (aEBooleanExpr instanceof AEBooleanTrue) {
            return new Pair<AETable, AEBooleanExpr>(aETable, aEBooleanExpr);
        }
        IBooleanExprHandler iBooleanExprHandler = this.m_opHandlerFactory.createFilterHandler(aETable.getTable());
        if (iBooleanExprHandler == null) {
            return new Pair<AETable, AEBooleanExpr>(aETable, aEBooleanExpr);
        }
        Pair<DSIExtJResultSet, AEBooleanExpr> pair = new AEPassdownFilter(iBooleanExprHandler).passdown(aEBooleanExpr);
        if (pair.key() != null) {
            aETable.setTable(pair.key());
        }
        if (pair.value() == null) {
            pair.setValue(new AEBooleanTrue());
        }
        return new Pair<AETable, AEBooleanExpr>(aETable, pair.value());
    }
}

