/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.aeprocessor.aeoptimizer;

import com.cloudera.impala.sqlengine.aeprocessor.aeoptimizer.NullExpressionVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AELikePredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AENot;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AENullPredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEQuantifiedComparison;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.impala.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.impala.support.exceptions.ErrorException;
import com.cloudera.impala.support.exceptions.InvalidOperationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class NullRejectVisitor
extends AEDefaultVisitor<Set<AERelationalExpr>> {
    private boolean m_isInNot = false;

    NullRejectVisitor() {
    }

    @Override
    public Set<AERelationalExpr> visit(AEAnd aEAnd) throws ErrorException {
        Set<AERelationalExpr> set = aEAnd.getLeftOperand().acceptVisitor(this);
        set.addAll((Collection<AERelationalExpr>)aEAnd.getRightOperand().acceptVisitor(this));
        return set;
    }

    @Override
    public Set<AERelationalExpr> visit(AEOr aEOr) throws ErrorException {
        Set<AERelationalExpr> set = aEOr.getLeftOperand().acceptVisitor(this);
        set.retainAll((Collection)aEOr.getRightOperand().acceptVisitor(this));
        return set;
    }

    @Override
    public Set<AERelationalExpr> visit(AEComparison aEComparison) throws ErrorException {
        Set<AERelationalExpr> set = aEComparison.getLeftOperand().acceptVisitor(NullExpressionVisitor.instance());
        set.addAll((Collection<AERelationalExpr>)aEComparison.getRightOperand().acceptVisitor(NullExpressionVisitor.instance()));
        return set;
    }

    @Override
    public Set<AERelationalExpr> visit(AEInPredicate aEInPredicate) throws ErrorException {
        return aEInPredicate.getLeftOperand().acceptVisitor(NullExpressionVisitor.instance());
    }

    @Override
    public Set<AERelationalExpr> visit(AELikePredicate aELikePredicate) throws ErrorException {
        return aELikePredicate.getLeftOperand().acceptVisitor(NullExpressionVisitor.instance());
    }

    @Override
    public Set<AERelationalExpr> visit(AEQuantifiedComparison aEQuantifiedComparison) throws ErrorException {
        return aEQuantifiedComparison.getLeftOperand().acceptVisitor(NullExpressionVisitor.instance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AERelationalExpr> visit(AENot aENot) throws ErrorException {
        if (!this.m_isInNot) {
            this.m_isInNot = true;
            try {
                AEBooleanExpr aEBooleanExpr = aENot.getOperand();
                if (aEBooleanExpr instanceof AENullPredicate) {
                    Set<AERelationalExpr> set = ((AENullPredicate)aEBooleanExpr).getOperand().acceptVisitor(NullExpressionVisitor.instance());
                    return set;
                }
                Set<AERelationalExpr> set = aEBooleanExpr.acceptVisitor(this);
                return set;
            }
            finally {
                this.m_isInNot = false;
            }
        }
        return new HashSet<AERelationalExpr>();
    }

    @Override
    protected Set<AERelationalExpr> defaultVisit(IAENode iAENode) throws ErrorException {
        if (iAENode instanceof AEBooleanExpr) {
            return new HashSet<AERelationalExpr>();
        }
        throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{iAENode.toString()});
    }
}

