/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.hash;

import com.cloudera.impala.sqlengine.executor.etree.hash.IRowBinaryPredicate;
import com.cloudera.impala.sqlengine.executor.etree.relation.ETHashAggregate;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.HasherFactory;
import com.cloudera.impala.sqlengine.utilities.ExternalAlgorithmUtil;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.io.File;

public class HashPartitionProperties {
    private ILogger m_logger;
    private ETHashAggregate.AggregateProjectionInfo m_aggregateProjection;
    private ETHashAggregate.OperandProjectionInfo m_operandProjection;
    private ExternalAlgorithmUtil.ExternalAlgorithmProperties m_extAlgProps;
    private IRowBinaryPredicate m_predicate;
    private HasherFactory m_hashFactory;

    public HashPartitionProperties(HasherFactory hasherFactory, IRowBinaryPredicate iRowBinaryPredicate, ETHashAggregate.AggregateProjectionInfo aggregateProjectionInfo, ETHashAggregate.OperandProjectionInfo operandProjectionInfo, ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties, ILogger iLogger) {
        this.m_hashFactory = hasherFactory;
        this.m_aggregateProjection = aggregateProjectionInfo;
        this.m_operandProjection = operandProjectionInfo;
        this.m_extAlgProps = externalAlgorithmProperties;
        this.m_predicate = iRowBinaryPredicate;
        this.m_logger = iLogger;
    }

    public IRowBinaryPredicate getEqualityPredicate() {
        return this.m_predicate;
    }

    public HasherFactory getHashFactory() {
        return this.m_hashFactory;
    }

    public ETHashAggregate.AggregateProjectionInfo getAggregateProjection() {
        return this.m_aggregateProjection;
    }

    public ETHashAggregate.OperandProjectionInfo getOperandProjection() {
        return this.m_operandProjection;
    }

    public ExternalAlgorithmUtil.ExternalAlgorithmProperties getExternalAlgorithmProperties() {
        return this.m_extAlgProps;
    }

    public ILogger getLogger() {
        return this.m_logger;
    }

    public File getStorageDir() throws ErrorException {
        return this.getExternalAlgorithmProperties().getStorageDir();
    }

    public int getMaxDataLen() {
        return this.getExternalAlgorithmProperties().getCellMemoryLimit();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ILogger m_logger;
        private ETHashAggregate.AggregateProjectionInfo m_aggregateProjection;
        private ETHashAggregate.OperandProjectionInfo m_operandProjection;
        private ExternalAlgorithmUtil.ExternalAlgorithmProperties m_extAlgProp;
        private IRowBinaryPredicate m_predicate;

        private Builder() {
        }

        public Builder logger(ILogger iLogger) {
            this.m_logger = iLogger;
            return this;
        }

        public Builder aggregateProjection(ETHashAggregate.AggregateProjectionInfo aggregateProjectionInfo) {
            this.m_aggregateProjection = aggregateProjectionInfo;
            return this;
        }

        public Builder equalityPredicate(IRowBinaryPredicate iRowBinaryPredicate) {
            this.m_predicate = iRowBinaryPredicate;
            return this;
        }

        public Builder extAlgorithmProperties(ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties) {
            this.m_extAlgProp = externalAlgorithmProperties;
            return this;
        }

        public Builder operandProjection(ETHashAggregate.OperandProjectionInfo operandProjectionInfo) {
            this.m_operandProjection = operandProjectionInfo;
            return this;
        }

        public HashPartitionProperties build() throws ErrorException {
            return new HashPartitionProperties(new HasherFactory(), this.m_predicate, this.m_aggregateProjection, this.m_operandProjection, this.m_extAlgProp, this.m_logger);
        }
    }
}

