/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.relation;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.CursorType;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.IETBinaryNode;
import com.cloudera.impala.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.impala.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.impala.support.exceptions.ErrorException;

public final class ETUnionAll
extends ETRelationalExpr
implements IETBinaryNode<ETRelationalExpr, ETRelationalExpr> {
    private final ETRelationalExpr m_leftOperand;
    private final ETRelationalExpr m_rightOperand;
    private boolean m_isOnLeftOperand = true;

    public ETUnionAll(ETRelationalExpr eTRelationalExpr, ETRelationalExpr eTRelationalExpr2, boolean[] blArray) {
        super(blArray);
        assert (eTRelationalExpr.getColumnCount() == eTRelationalExpr2.getColumnCount());
        this.m_leftOperand = eTRelationalExpr;
        this.m_rightOperand = eTRelationalExpr2;
    }

    @Override
    public void close(boolean bl) {
        this.getLeftOperand().close(bl);
        this.getRightOperand().close(bl);
    }

    @Override
    public boolean isOpen() {
        return this.getLeftOperand().isOpen() && this.getRightOperand().isOpen();
    }

    @Override
    public void reset() throws ErrorException {
        this.getLeftOperand().reset();
        this.getRightOperand().reset();
        this.m_isOnLeftOperand = true;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public IColumn getColumn(int n) {
        if (this.m_isOnLeftOperand) {
            return this.getLeftOperand().getColumn(n);
        }
        return this.getRightOperand().getColumn(n);
    }

    @Override
    public int getColumnCount() {
        assert (this.getLeftOperand().getColumnCount() == this.getRightOperand().getColumnCount());
        return this.getLeftOperand().getColumnCount();
    }

    @Override
    public long getRowCount() throws ErrorException {
        long l = this.getLeftOperand().getRowCount();
        if (-1L == l) {
            return l;
        }
        long l2 = this.getRightOperand().getRowCount();
        if (-1L == l2) {
            return l2;
        }
        return l + l2;
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        this.getLeftOperand().open(cursorType);
        this.getRightOperand().open(cursorType);
        this.m_isOnLeftOperand = true;
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.getCurrentOperand().retrieveData(n, eTDataRequest);
    }

    @Override
    public String getLogString() {
        return "ETUnionAll";
    }

    @Override
    public ETRelationalExpr getChild(int n) throws IndexOutOfBoundsException {
        if (0 == n) {
            return this.getLeftOperand();
        }
        if (1 == n) {
            return this.getRightOperand();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ETRelationalExpr getLeftOperand() {
        return this.m_leftOperand;
    }

    @Override
    public ETRelationalExpr getRightOperand() {
        return this.m_rightOperand;
    }

    @Override
    protected boolean doMove() throws ErrorException {
        if (this.m_isOnLeftOperand) {
            if (this.m_leftOperand.move()) {
                return true;
            }
            this.m_isOnLeftOperand = false;
        }
        return this.m_rightOperand.move();
    }

    private ETRelationalExpr getCurrentOperand() {
        return this.m_isOnLeftOperand ? this.getLeftOperand() : this.getRightOperand();
    }
}

