/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.temptable;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.exceptions.UtilsException;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.AESortSpec;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.executor.etree.ETCancelState;
import com.cloudera.impala.sqlengine.executor.etree.temptable.RowComparator;
import com.cloudera.impala.sqlengine.executor.etree.temptable.SortedTemporaryTable;
import com.cloudera.impala.sqlengine.utilities.ExternalAlgorithmUtil;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.io.File;
import java.util.List;

public class TemporaryTableBuilder {
    private List<AESortSpec> m_sortSpecList = null;
    private final List<IColumn> m_metadata;
    private SqlDataEngine m_dataEngine;
    private boolean[] m_dataNeeded;
    private ExternalAlgorithmUtil.ExternalAlgorithmProperties m_extProperty;
    private final ETCancelState m_cancelState;

    public TemporaryTableBuilder(List<IColumn> list, SqlDataEngine sqlDataEngine, ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties, ETCancelState eTCancelState, boolean[] blArray) {
        this.m_metadata = list;
        this.m_dataNeeded = (boolean[])blArray.clone();
        this.m_dataEngine = sqlDataEngine;
        this.m_extProperty = externalAlgorithmProperties;
        this.m_cancelState = eTCancelState;
    }

    public TemporaryTableBuilder sortSpec(List<AESortSpec> list) {
        this.m_sortSpecList = list;
        return this;
    }

    public SortedTemporaryTable buildSorted() throws ErrorException {
        int n;
        RowComparator.NullCollation nullCollation = null;
        try {
            n = this.m_dataEngine.getContext().getConnProperty(89).getInt();
            switch (n) {
                case 4: {
                    nullCollation = RowComparator.NullCollation.NULLS_END;
                    break;
                }
                case 0: {
                    nullCollation = RowComparator.NullCollation.NULLS_HI;
                    break;
                }
                case 1: {
                    nullCollation = RowComparator.NullCollation.NULLS_LO;
                    break;
                }
                case 2: {
                    nullCollation = RowComparator.NullCollation.NULLS_START;
                }
            }
        }
        catch (UtilsException utilsException) {
            throw SQLEngineExceptionFactory.invalidOperationException(utilsException.getMessage());
        }
        n = this.m_extProperty.getCellMemoryLimit();
        long l = this.m_extProperty.getBlockSize();
        long l2 = ExternalAlgorithmUtil.calculateRowSize(this.m_metadata, this.m_dataNeeded, n);
        l = Math.max(l, l2);
        TemporaryTableProperties temporaryTableProperties = new TemporaryTableProperties(this.m_extProperty.getStorageDir(), n, l, l2, this.m_extProperty.getMaxNumOpenFiles(), this.m_extProperty.getLogger(), "Sort");
        assert (null != this.m_sortSpecList);
        SortedTemporaryTable sortedTemporaryTable = new SortedTemporaryTable(this.m_metadata, temporaryTableProperties, this.m_sortSpecList, nullCollation, this.m_cancelState, this.m_dataNeeded);
        return sortedTemporaryTable;
    }

    public static final class TemporaryTableProperties {
        final int m_maxDataLen;
        final long m_blockSize;
        final long m_rowSize;
        final int m_maxOpenFiles;
        final File m_storageDir;
        final ILogger m_logger;
        final String m_operationName;

        public TemporaryTableProperties(File file, int n, long l, long l2, int n2, ILogger iLogger, String string) {
            this.m_storageDir = file;
            this.m_blockSize = l;
            this.m_maxDataLen = n;
            this.m_rowSize = l2;
            this.m_maxOpenFiles = n2;
            this.m_logger = iLogger;
            this.m_operationName = string;
        }
    }
}

