/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.value;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.ParameterType;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.impala.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.IETNode;
import com.cloudera.impala.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.impala.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.cloudera.impala.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.impala.support.exceptions.ErrorException;

public class ETParameter
extends ETValueExpr {
    private DataWrapper m_data;
    private DataWrapper m_convertData = null;
    private boolean m_isOpened;
    private short m_type;
    private ParameterType m_paramType = ParameterType.INPUT;

    public ETParameter(IColumn iColumn) {
        this.m_type = iColumn.getTypeMetadata().getType();
        this.m_data = null;
        this.m_isOpened = false;
    }

    public void updateParamType(ParameterType parameterType) {
        this.m_paramType = parameterType;
    }

    public ParameterType getParamType() {
        return this.m_paramType;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void close(boolean bl) {
        this.m_isOpened = false;
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpened;
    }

    public void setInputData(DataWrapper dataWrapper) {
        if (this.isOpen()) {
            throw new IllegalStateException("Changing parameter value during execution.");
        }
        if (dataWrapper.getType() != this.m_type) {
            throw new IllegalArgumentException(String.format("Incompitable type. required : %s, set : %s", TypeUtilities.sqlTypeToString(this.m_type), TypeUtilities.sqlTypeToString((short)dataWrapper.getType())));
        }
        this.m_data = dataWrapper;
    }

    public void setOutputData(DataWrapper dataWrapper) {
        if (this.isOpen()) {
            throw new IllegalStateException("Changing parameter value during execution.");
        }
        this.m_data = dataWrapper;
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public void open() {
        this.m_isOpened = true;
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        if (this.m_data == null) {
            throw new IllegalStateException("Unresolved parameter.");
        }
        ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
        iSqlDataWrapper.setValue(this.m_data);
        if (iSqlDataWrapper.isNull()) {
            return false;
        }
        TypeMetadata typeMetadata = eTDataRequest.getColumn().getTypeMetadata();
        if (typeMetadata.isCharacterType()) {
            return DataRetrievalUtil.retrieveCharData(iSqlDataWrapper, eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), eTDataRequest.getColumn().getColumnLength(), this.getWarningListener());
        }
        if (typeMetadata.isBinaryType()) {
            return DataRetrievalUtil.retrieveBinaryData(iSqlDataWrapper, eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), eTDataRequest.getColumn().getColumnLength(), this.getWarningListener());
        }
        return false;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    public DataWrapper getData() {
        return this.m_data;
    }

    @Override
    public DataWrapper getCachedDataWrapper() {
        return this.m_convertData;
    }

    @Override
    public void setCachedDataWrapper(DataWrapper dataWrapper) {
        this.m_convertData = dataWrapper;
    }
}

