/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.dsi.core.utilities.impl.future;

import com.cloudera.impala.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.impala.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.cloudera.impala.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.dsi.exceptions.ConversionFailed;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class TimeJDBCDataSource
extends ConvertingJDBCDataSource {
    private final int m_fracSecPrec;

    public TimeJDBCDataSource(IWarningListener iWarningListener, TypeMetadata typeMetadata) {
        super(iWarningListener);
        this.m_fracSecPrec = typeMetadata.getPrecision();
    }

    protected final int getFractionalSecondsPrecision() {
        return this.m_fracSecPrec;
    }

    protected abstract boolean get(Calendar var1) throws ErrorException;

    protected Time doGetTime(Calendar calendar) throws ErrorException {
        assert (calendar != null);
        if (this.get(calendar)) {
            this.setWasNull(false);
            return new Time(calendar.getTimeInMillis());
        }
        this.setWasNull(true);
        return null;
    }

    @Override
    public Time get() throws ErrorException {
        return this.doGetTime(this.getLocalCalendarForConversions());
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        Time time = this.get();
        if (time == null) {
            return null;
        }
        return NonTrivialJDBCConversions.timeToString(time, this.getLocalCalendarForConversions(), this.m_fracSecPrec);
    }

    @Override
    public Time getTime(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        return this.doGetTime(calendar);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        if (this.get(calendar)) {
            this.setWasNull(false);
            return new Timestamp(calendar.getTimeInMillis());
        }
        this.setWasNull(true);
        return null;
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 92: 
            case 93: 
            case 2000: {
                return true;
            }
        }
        return this.isCharType(n);
    }
}

