/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.core;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.dsi.dataengine.impl.DSIMetadataOnlyResultSet;
import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionResults;
import com.cloudera.impala.dsi.dataengine.utilities.ParameterInputValue;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.utils.HiveCommonGSSCredentialMap;
import com.cloudera.impala.jdbc.common.SPreparedStatement;
import com.cloudera.impala.jdbc.utils.WarningsUtils;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.ietf.jgss.GSSCredential;

public class CoreUtils {
    private static final int BIG_DECIMAL_INTERVAL_PRECISION = 53;
    private static final int BIG_DECIMAL_SCALE = 38;
    private static final int LOG_INDEX_SHOW_ALL = -1;
    private static final String HOST_DELIMITER = "//";
    private static final String PORT_DELIMITER = ":";
    private static final String SCHEMA_SEPERATOR = "/";
    private static final String KEY_VALUE_DELIMITER = ";";
    private static final String VALUE_DELIMITER = "=";
    private static final char SQL_QUERY_PARAMETER_SIGN = '?';
    public static final String VARCHAR_DATATYPE_TOKEN = "VARCHAR";
    public static final String CHAR_DATATYPE_TOKEN = "CHAR";
    public static final String DECIMAL_DATATYPE_TOKEN = "DECIMAL";
    public static final String MAP_DATATYPE_TOKEN = "MAP";
    public static final String ARRAY_DATATYPE_TOKEN = "ARRAY";
    public static final String STRUCT_DATATYPE_TOKEN = "STRUCT";
    public static final String UNION_DATATYPE_TOKEN = "UNIONTYPE";
    public static final String UNION_DATATYPE_TOKEN_HS2 = "UNION";
    public static final String BRACKET_TOKEN = "(";
    public static final String ANGULAR_BRACKET_TOKEN = "<";
    public static final int CHAR_MAX_LENGTH = 255;
    public static final int VARCHAR_MAX_LENGTH = 65535;

    public static void alterBigDecimalMetadata(int n, BigDecimal bigDecimal, HashMap<Integer, TypeMetadata> hashMap, HiveJDBCSettings hiveJDBCSettings) {
        if (bigDecimal.scale() > 38) {
            TypeMetadata typeMetadata = new TypeMetadata(8, "SQL_DOUBLE", 38, (short)bigDecimal.precision(), 53, true);
            hashMap.put(n - 1, typeMetadata);
        } else if (hashMap.get(n - 1).getType() == 2) {
            TypeMetadata typeMetadata = hashMap.get(n - 1);
            typeMetadata.setScale((short)bigDecimal.scale());
        }
    }

    public static String appendInsertParameters(String string, ArrayList<ParameterInputValue> arrayList, List<Integer> list) throws ErrorException {
        if (list.size() != arrayList.size()) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_PARAMETER_QUERY_BUILD_ERR_WRONG_QUERY_FORMAT.name(), "Number of parameters does not match");
            throw errorException;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" ,(");
        ArrayList<String> arrayList2 = CoreUtils.getParameterValues(arrayList, list);
        for (int i = 0; i < arrayList2.size(); ++i) {
            stringBuilder.append(arrayList2.get(i));
            if (i >= arrayList2.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String buildBaseParameterQuery(String string, ArrayList<ParameterInputValue> arrayList, List<Integer> list, Integer n) throws ErrorException {
        if (list.size() != arrayList.size()) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_PARAMETER_QUERY_BUILD_ERR_WRONG_QUERY_FORMAT.name(), "Number of parameters does not match");
            throw errorException;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        ArrayList<String> arrayList2 = CoreUtils.getParameterValues(arrayList, false, string, list);
        for (int i = 0; i < n; ++i) {
            if (!list.contains(i)) {
                stringBuilder.append(string.charAt(i));
                continue;
            }
            stringBuilder.append(arrayList2.get(n2));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String buildInsertQueryWithParameters(String string, Iterator<ExecutionContext> iterator) throws ErrorException {
        int n = string.length();
        List<Integer> list = CoreUtils.getIndexList(string);
        if (list.size() == 0) {
            return string;
        }
        String string2 = CoreUtils.buildQueryWithParameters(string, iterator, n, list);
        ArrayList<ParameterInputValue> arrayList = new ArrayList<ParameterInputValue>();
        while (iterator.hasNext()) {
            arrayList.clear();
            ExecutionContext executionContext = iterator.next();
            for (int i = 0; i < executionContext.getInputs().size(); ++i) {
                ParameterInputValue parameterInputValue = executionContext.getInputs().get(i);
                arrayList.add(parameterInputValue);
            }
            string2 = CoreUtils.appendInsertParameters(string2, arrayList, list);
        }
        return string2;
    }

    public static String buildQueryWithParameters(String string, Iterator<ExecutionContext> iterator) throws ErrorException {
        int n = string.length();
        List<Integer> list = CoreUtils.getIndexList(string);
        if (list.size() == 0) {
            return string;
        }
        return CoreUtils.buildQueryWithParameters(string, iterator, n, list);
    }

    public static String buildQueryWithParameters(String string, Iterator<ExecutionContext> iterator, int n, List<Integer> list) throws ErrorException {
        Object object;
        ArrayList<ParameterInputValue> arrayList = new ArrayList<ParameterInputValue>();
        if (iterator.hasNext()) {
            object = iterator.next();
            for (int i = 0; i < ((ExecutionContext)object).getInputs().size(); ++i) {
                ParameterInputValue parameterInputValue = ((ExecutionContext)object).getInputs().get(i);
                arrayList.add(parameterInputValue);
            }
        }
        object = CoreUtils.buildBaseParameterQuery(string, arrayList, list, n);
        return object;
    }

    public static List<String> buildUpdateQueryWithParameters(String string, Iterator<ExecutionContext> iterator) throws ErrorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        List<Integer> list = CoreUtils.getIndexList(string);
        if (list.size() == 0) {
            arrayList.add(string);
            return arrayList;
        }
        ArrayList<ParameterInputValue> arrayList2 = new ArrayList<ParameterInputValue>();
        while (iterator.hasNext()) {
            arrayList2.clear();
            ExecutionContext executionContext = iterator.next();
            for (int i = 0; i < executionContext.getInputs().size(); ++i) {
                ParameterInputValue parameterInputValue = executionContext.getInputs().get(i);
                arrayList2.add(parameterInputValue);
            }
            String string2 = CoreUtils.buildBaseParameterQuery(string, arrayList2, list, n);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static int extractPatchNumber(String string) {
        try {
            return new Integer(string);
        }
        catch (Exception exception) {
            String string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                string2 = string.substring(0, i);
                break;
            }
            if (string2.isEmpty()) {
                return 0;
            }
            return new Integer(string2);
        }
    }

    public static String createDriverVersion(int n, int n2, int n3, int n4) {
        return MessageFormat.format("{0,number,00}.{1,number,00}.{2,number,00}.{3,number,0000}", n, n2, n3, n4);
    }

    public static List<Integer> getIndexList(String string) throws ErrorException {
        int n = 0;
        int n2 = string.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = CoreUtils.parseNativeQueryParameters(string, '?', n, n2, arrayList);
        if (arrayList.size() != 0 && bl) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_PARAMETER_QUERY_BUILD_ERR_NUM_OF_PARAMS_MUST_MATCH.name(), "Wrong parameter query format");
            throw errorException;
        }
        return arrayList;
    }

    public static ArrayList<String> getParameterValues(ArrayList<ParameterInputValue> arrayList, List<Integer> list) throws ErrorException {
        return CoreUtils.getParameterValues(arrayList, false, null, list);
    }

    public static ArrayList<String> getParameterValues(ArrayList<ParameterInputValue> arrayList, boolean bl, String string, List<Integer> list) throws ErrorException {
        int n;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList3.add(false);
        }
        CoreUtils.isRegexpFunction(string, arrayList3, list);
        block21: for (n = 0; n < arrayList.size(); ++n) {
            Object object;
            String string2 = "";
            short s = arrayList.get(n).getMetadata().getTypeMetadata().getType();
            try {
                DataWrapper dataWrapper = arrayList.get(n).getData();
                if (null != dataWrapper) {
                    switch (s) {
                        case 16: {
                            if (null == dataWrapper.getBoolean()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getBoolean().toString());
                            continue block21;
                        }
                        case -6: {
                            if (null == dataWrapper.getTinyInt()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getTinyInt().toString());
                            continue block21;
                        }
                        case 5: {
                            if (null == dataWrapper.getSmallInt()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getSmallInt().toString());
                            continue block21;
                        }
                        case 4: {
                            if (null == dataWrapper.getInteger()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getInteger().toString());
                            continue block21;
                        }
                        case -5: {
                            if (null == dataWrapper.getBigInt()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getBigInt().toString());
                            continue block21;
                        }
                        case 3: {
                            if (null == dataWrapper.getDecimal()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getDecimal().toString());
                            continue block21;
                        }
                        case -2: {
                            if (null == dataWrapper.getBinary()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getBinary().toString());
                            continue block21;
                        }
                        case 8: {
                            if (null == dataWrapper.getDouble()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getDouble().toString());
                            continue block21;
                        }
                        case 7: {
                            if (null == dataWrapper.getReal()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getReal().toString());
                            continue block21;
                        }
                        case 6: {
                            if (null == dataWrapper.getFloat()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getFloat().toString());
                            continue block21;
                        }
                        case 93: {
                            if (null == dataWrapper.getTimestamp()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            object = new StringBuilder();
                            ((StringBuilder)object).append("'").append(dataWrapper.getTimestamp().toString()).append("'");
                            arrayList2.add(((StringBuilder)object).toString());
                            continue block21;
                        }
                        case 1: {
                            if (null == dataWrapper.getChar()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            object = dataWrapper.getChar();
                            arrayList2.add(CoreUtils.createParamValueForStringType((String)object, bl, arrayList3.get(n)));
                            continue block21;
                        }
                        case 12: {
                            if (null == dataWrapper.getVarChar()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            object = dataWrapper.getVarChar();
                            arrayList2.add(CoreUtils.createParamValueForStringType((String)object, bl, arrayList3.get(n)));
                            continue block21;
                        }
                        case -1: {
                            if (null == dataWrapper.getLongVarChar()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            object = dataWrapper.getLongVarChar();
                            arrayList2.add(CoreUtils.createParamValueForStringType((String)object, bl, arrayList3.get(n)));
                            continue block21;
                        }
                        case 2: {
                            if (null == dataWrapper.getNumeric()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            arrayList2.add(dataWrapper.getNumeric().toString());
                            continue block21;
                        }
                        case 91: {
                            if (null == dataWrapper.getDate()) {
                                arrayList2.add(null);
                                continue block21;
                            }
                            object = new StringBuilder();
                            ((StringBuilder)object).append("'").append(dataWrapper.getDate().toString()).append("'");
                            arrayList2.add(((StringBuilder)object).toString());
                            continue block21;
                        }
                        default: {
                            string2 = HiveJDBCMessageKey.HIVE_PARAMETER_QUERY_DATA_TYPE_ERR_NON_SUPPORT_DATA_TYPE.name();
                            object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(string2, "Data Type not supported");
                            throw object;
                        }
                    }
                }
                string2 = HiveJDBCMessageKey.HIVE_PARAMETER_QUERY_DATA_TYPE_ERR_NULL_DATA_TYPE.name();
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(string2, "Parameter data type is null");
                throw object;
            }
            catch (Exception exception) {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(string2, exception.getMessage());
                ((Throwable)object).initCause(exception);
                throw object;
            }
        }
        return arrayList2;
    }

    public static boolean isComplexType(IColumn iColumn) {
        String string = iColumn.getTypeMetadata().getTypeName();
        if (null == string) {
            return false;
        }
        return string.toUpperCase().startsWith(MAP_DATATYPE_TOKEN) || string.toUpperCase().startsWith(ARRAY_DATATYPE_TOKEN) || string.toUpperCase().startsWith(STRUCT_DATATYPE_TOKEN) || string.toUpperCase().startsWith(UNION_DATATYPE_TOKEN) || string.toUpperCase().startsWith(UNION_DATATYPE_TOKEN_HS2);
    }

    public static void modifyColumnNameToLowerCase(ExecutionResults executionResults) throws ErrorException {
        try {
            Iterator<ExecutionResult> iterator = executionResults.getResultItr();
            while (iterator.hasNext()) {
                Object object = iterator.next().getResult();
                if (!(object instanceof DSIMetadataOnlyResultSet)) continue;
                List list = ((DSIMetadataOnlyResultSet)object).getSelectColumns();
                for (IColumn iColumn : list) {
                    if (!(iColumn instanceof ColumnMetadata)) continue;
                    String string = iColumn.getName().toLowerCase();
                    ((ColumnMetadata)iColumn).setLabel(string);
                    ((ColumnMetadata)iColumn).setName(string);
                }
            }
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_INITIALIZATION_ERR.name(), "cannot initial the metadata");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    public static int parameterCounter(String string) {
        ArrayList<Integer> arrayList;
        int n = 0;
        int n2 = string.length();
        boolean bl = CoreUtils.parseNativeQueryParameters(string, '?', n, n2, arrayList = new ArrayList<Integer>());
        if (bl) {
            return -1;
        }
        return arrayList.size();
    }

    public static boolean parseSubName(String string, Properties properties) {
        Object object;
        Object object2;
        if (null == string || 0 == string.length() || !string.startsWith(HOST_DELIMITER)) {
            return false;
        }
        String string2 = string.trim().substring(HOST_DELIMITER.length());
        if (0 == string2.length()) {
            return false;
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = string2.split(KEY_VALUE_DELIMITER);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0 && !stringArray[i].contains(VALUE_DELIMITER)) {
                object2 = new String[]{"Host", "Port", "ConnSchema"};
                object = stringArray[0].split(PORT_DELIMITER);
                String[] stringArray2 = null;
                String[] stringArray3 = null;
                stringArray3 = ((String)object[0]).split(SCHEMA_SEPERATOR);
                treeMap.put(object2[0].trim(), stringArray3[0]);
                if (stringArray3.length == 2) {
                    treeMap.put(object2[2].trim(), stringArray3[1]);
                    continue;
                }
                if (((Object)object).length != 2) continue;
                stringArray2 = ((String)object[1]).split(SCHEMA_SEPERATOR);
                if (null != stringArray2 && stringArray2.length == 2) {
                    treeMap.put(object2[1].trim(), stringArray2[0]);
                    treeMap.put(object2[2].trim(), stringArray2[1]);
                    continue;
                }
                if (null == stringArray2) continue;
                treeMap.put(object2[1].trim(), stringArray2[0]);
                treeMap.put(object2[2].trim(), "NULL");
                continue;
            }
            object2 = stringArray[i];
            if (':' == object2.charAt(0)) {
                object2 = object2.substring(1);
            }
            if (2 > ((String[])(object = object2.split(VALUE_DELIMITER, 2))).length) {
                treeMap.put(object[0].trim(), "");
                continue;
            }
            treeMap.put(object[0].trim(), object[1]);
        }
        Object object3 = properties.get("userGSSCredential");
        if (null != object3 && object3 instanceof GSSCredential) {
            object2 = HiveCommonGSSCredentialMap.put((GSSCredential)object3);
            treeMap.put("userGSSCredentialID", object2);
        }
        properties.remove("userGSSCredential");
        object2 = properties.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (treeMap.containsKey(object)) continue;
            treeMap.put(((String)object).trim(), properties.getProperty((String)object));
        }
        properties.clear();
        properties.putAll((Map<?, ?>)treeMap);
        return true;
    }

    public static void postWarning(Exception exception, IWarningListener iWarningListener, WarningCode warningCode, int n, String string, ILogger iLogger, boolean bl) {
        if (exception instanceof ErrorException) {
            ErrorException errorException = (ErrorException)exception;
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
        }
        WarningsUtils.postWarning(new Warning(warningCode, n, string, new String[]{exception.getMessage()}), iWarningListener, iLogger, bl);
    }

    public static void postWarning(Exception exception, IWarningListener iWarningListener, WarningCode warningCode, int n, String string, String string2, ILogger iLogger, boolean bl) {
        if (exception instanceof ErrorException) {
            ErrorException errorException = (ErrorException)exception;
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
        }
        WarningsUtils.postWarning(new Warning(warningCode, n, string, new String[]{string2 + exception.getMessage()}), iWarningListener, iLogger, bl);
    }

    public static void removeComplexColumns(ExecutionResults executionResults) throws ErrorException {
        try {
            Iterator<ExecutionResult> iterator = executionResults.getResultItr();
            while (iterator.hasNext()) {
                Object object = iterator.next().getResult();
                if (!(object instanceof DSIMetadataOnlyResultSet)) continue;
                List list = ((DSIMetadataOnlyResultSet)object).getSelectColumns();
                CoreUtils.removeComplexColumns(list);
            }
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_INITIALIZATION_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    public static void removeComplexColumns(List<? extends IColumn> list) throws ErrorException {
        Object object;
        Iterator<? extends IColumn> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!CoreUtils.isComplexType((IColumn)object)) continue;
            iterator.remove();
        }
        if (0 == list.size()) {
            object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.IMPALA_EMPTY_SELECT_LIST_DUE_TO_COMPLEX_COLUMNS_ONLY.name());
            throw object;
        }
    }

    public static boolean setBigDecimalObject(SPreparedStatement sPreparedStatement, int n, Object object, HiveJDBCSettings hiveJDBCSettings) throws SQLException {
        if (object instanceof BigDecimal) {
            int n2 = ((BigDecimal)object).scale();
            if (n2 < 38) {
                sPreparedStatement.setObject(n, object, 3, n2);
            } else {
                int n3 = 10;
                if (null != hiveJDBCSettings) {
                    n3 = hiveJDBCSettings.m_decimalColumnScale;
                }
                sPreparedStatement.setObject(n, object, 8, n3);
            }
            return true;
        }
        return false;
    }

    public static boolean setBigDecimalObject(SPreparedStatement sPreparedStatement, int n, Object object, int n2, HiveJDBCSettings hiveJDBCSettings) throws SQLException {
        if (object instanceof BigDecimal) {
            int n3 = 10;
            if (null != hiveJDBCSettings) {
                n3 = hiveJDBCSettings.m_decimalColumnScale;
            }
            sPreparedStatement.setObject(n, object, n2, n3);
            return true;
        }
        return false;
    }

    private static String createParamValueForStringType(String string, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        string = bl2 ? string.replaceAll("[\\=\\!\\<\\>\\:\\-\\!\\'\\.\\[\\]\\{\\}\\(\\)\\*\\+\\?\\|\\^\\$\\\\]", "\\\\$0") : string.replaceAll("[\\'\\\\]", "\\\\$0");
        boolean bl3 = bl = bl && 65535 >= string.length();
        if (bl) {
            stringBuilder.append("CAST(");
        }
        stringBuilder.append("'").append(string).append("'");
        if (bl) {
            if (string.length() <= 255) {
                stringBuilder.append(" AS CHAR(");
            } else {
                stringBuilder.append(" AS VARCHAR(");
            }
            if (string.isEmpty()) {
                stringBuilder.append(1);
            } else {
                stringBuilder.append(string.length());
            }
            stringBuilder.append("))");
        }
        return stringBuilder.toString();
    }

    private static boolean parseNativeQueryParameters(String string, char c, int n, int n2, ArrayList<Integer> arrayList) {
        boolean bl = false;
        while (n < n2) {
            switch (string.charAt(n)) {
                case '[': {
                    int n3 = string.substring(n, n2).indexOf("]");
                    if (n3 != -1) {
                        n = n3 + n;
                        break;
                    }
                    bl = true;
                    break;
                }
                case '\'': {
                    int n4 = string.substring(n + 1, n2).indexOf(39);
                    if (n4 != -1) {
                        n = n4 + n + 1;
                        break;
                    }
                    bl = true;
                    break;
                }
                case '\"': {
                    int n5 = string.substring(n + 1, n2).indexOf(34);
                    if (n5 != -1) {
                        n = n5 + n + 1;
                        break;
                    }
                    bl = true;
                    break;
                }
                case '-': {
                    if (n + 1 >= n2 || string.charAt(n + 1) != '-') break;
                    int n6 = string.substring(n, n2).indexOf("\n");
                    if (n6 != -1) {
                        n = n6 + n;
                        break;
                    }
                    bl = true;
                    break;
                }
                case '/': {
                    if (n + 2 >= n2 || string.charAt(n + 1) != '*') break;
                    int n6 = string.substring(n, n2).indexOf("*/");
                    if (n6 != -1) {
                        n = n6 + n;
                        break;
                    }
                    bl = true;
                    break;
                }
                case '`': {
                    int n6 = string.substring(n + 1, n2).indexOf(96);
                    if (n6 != -1) {
                        n = n6 + n + 1;
                        break;
                    }
                    bl = true;
                }
            }
            if (string.charAt(n) == c) {
                arrayList.add(n);
                ++n;
                continue;
            }
            ++n;
        }
        return bl;
    }

    private static ArrayList<Boolean> isRegexpFunction(String string, ArrayList<Boolean> arrayList, List<Integer> list) {
        if (null == string) {
            return arrayList;
        }
        String string2 = string.trim();
        if (null == list) {
            return arrayList;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            String string3;
            string2 = string2.substring(0, list.get(i)).trim();
            try {
                string3 = string2.substring(string2.lastIndexOf(" ")).trim();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return arrayList;
            }
            if (!string3.equalsIgnoreCase("regexp")) continue;
            arrayList.set(i, true);
        }
        return arrayList;
    }

    public static String redactQuery(String string, HiveJDBCSettings hiveJDBCSettings) {
        if (hiveJDBCSettings.m_errMsgAndLogQueryRedactIndex < string.length() && hiveJDBCSettings.m_errMsgAndLogQueryRedactIndex != -1) {
            return string.substring(0, hiveJDBCSettings.m_errMsgAndLogQueryRedactIndex) + "***";
        }
        return string;
    }
}

