/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine;

import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.core.utilities.Variants;
import com.cloudera.impala.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.cloudera.impala.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.cloudera.impala.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.impala.dsi.dataengine.interfaces.IQueryExecutor;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.impala.dsi.exceptions.ParsingException;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.core.HiveJDBCStatement;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCCoercionHandler;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCLimitChecker;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata;
import com.cloudera.impala.hivecommon.dataengine.IHiveCustomScalarFnFactory;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCCatalogOnlyMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCCatalogSchemaOnlyMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCColumnsMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCSchemaOnlyMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCTablesMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCTypeInfoMetadataSource;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.sqlengine.SQLEngineGenericContext;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.cloudera.impala.sqlengine.dsiext.dataengine.CustomScalarFunction;
import com.cloudera.impala.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.impala.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.impala.sqlengine.dsiext.dataengine.OpenTableType;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.impala.sqlengine.dsiext.dataengine.StoredProcedure;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineException;
import com.cloudera.impala.sqlengine.parser.IPTLimitChecker;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.Map;

public class HiveJDBCDataEngineWithLimitZeroPreparedStatementMetadata
extends SqlDataEngine {
    private HiveJDBCSettings m_settings;
    private IHiveClient m_hiveClient;
    private HiveJDBCStatement m_statement;
    private HiveJDBCCommonConnection m_connection;
    private AEStatements m_originalAEStatment;
    private SqlDataEngineContext m_originalDataContext;
    private boolean m_isDirectExecuteQuery;
    private ConnSettingRequestMap m_requestMap;
    private String m_cachedCurrentCatalog;
    private String m_cachedCurrentSchema;

    public HiveJDBCDataEngineWithLimitZeroPreparedStatementMetadata(HiveJDBCStatement hiveJDBCStatement, AEStatements aEStatements, SqlDataEngineContext sqlDataEngineContext, IHiveClient iHiveClient, HiveJDBCSettings hiveJDBCSettings, HiveJDBCCommonConnection hiveJDBCCommonConnection, boolean bl, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        super(hiveJDBCStatement);
        this.setProperty(3, Variants.makeWString("N"));
        if (hiveJDBCSettings.m_enableMultiCatalog) {
            this.setProperty(15, Variants.makeWString("N"));
        }
        LogUtilities.logFunctionEntrance(this.getLog(), hiveJDBCStatement);
        this.m_connection = (HiveJDBCCommonConnection)hiveJDBCStatement.getParentConnection();
        this.m_settings = hiveJDBCSettings;
        this.m_hiveClient = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_originalAEStatment = aEStatements;
        this.m_originalDataContext = sqlDataEngineContext;
        this.m_isDirectExecuteQuery = bl;
        this.m_requestMap = connSettingRequestMap;
    }

    @Override
    public ICoercionHandler createCoercionHandler() {
        return new HiveJDBCCoercionHandler(this.m_settings.m_useCustomCoercionMap, this.getLog());
    }

    @Override
    protected IPTLimitChecker getLimitChecker() throws ErrorException {
        HiveJDBCLimitChecker hiveJDBCLimitChecker = new HiveJDBCLimitChecker();
        hiveJDBCLimitChecker.initLimitCheckValues(this.getParentStatement().getParentConnection());
        return hiveJDBCLimitChecker;
    }

    @Override
    public CustomScalarFunction openScalarFunction(String string, int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string, n);
        IHiveCustomScalarFnFactory iHiveCustomScalarFnFactory = this.m_connection.getScalarFnHelper();
        if (null != iHiveCustomScalarFnFactory) {
            return iHiveCustomScalarFnFactory.createScalarFunction(string, n);
        }
        return null;
    }

    @Override
    public StoredProcedure openProcedure(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string, string2, string3);
        return null;
    }

    @Override
    public DSIExtJResultSet openTable(String string, String string2, String string3, OpenTableType openTableType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{string, string2, string3, openTableType});
        if (null == string || string.isEmpty() || this.m_settings.m_convertSyntheticCatalogToCurrCatalogForQuery && string.equalsIgnoreCase(this.m_settings.m_platformCatalog)) {
            string = this.m_cachedCurrentCatalog;
        }
        if (null == string2 || string2.isEmpty()) {
            string2 = this.m_cachedCurrentSchema;
        }
        return this.m_hiveClient.getTable(string, string2, string3);
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string);
        try {
            this.m_cachedCurrentCatalog = this.m_hiveClient.getCurrentCatalog();
            this.m_cachedCurrentSchema = this.m_hiveClient.getCurrentSchema();
            return super.prepare(string);
        }
        catch (SQLEngineException sQLEngineException) {
            sQLEngineException.loadMessage(SQLEngineGenericContext.getDefaultMsgSource(), this.m_hiveClient.getWarningListener().getLocale());
            LogUtilities.logWarning(sQLEngineException, this.getLog());
            throw sQLEngineException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_PREPARE_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{metadataSourceID, map, string, string2, bl});
        switch (metadataSourceID) {
            case TYPE_INFO: {
                return new HiveJDBCTypeInfoMetadataSource(this.getLog(), this.m_settings);
            }
            case CATALOG_SCHEMA_ONLY: {
                return new HiveJDBCCatalogSchemaOnlyMetadataSource(this.getLog(), null, null, null, this.m_hiveClient, this.m_settings);
            }
            case SCHEMA_ONLY: {
                return new HiveJDBCSchemaOnlyMetadataSource(this.getLog());
            }
            case CATALOG_ONLY: {
                return new HiveJDBCCatalogOnlyMetadataSource(this.getLog(), this.m_hiveClient);
            }
            case COLUMNS: {
                return new HiveJDBCColumnsMetadataSource(this.getLog(), map, null, null, this.m_hiveClient, this.m_settings);
            }
            case TABLES: {
                return new HiveJDBCTablesMetadataSource(this.getLog(), null, null, null, this.m_hiveClient, this.m_settings);
            }
            case TABLETYPE_ONLY: {
                return new DSITableTypeOnlyMetadataSource(this.getLog());
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }

    @Override
    protected SqlQueryExecutor createQueryExecutor(AEStatements aEStatements) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), aEStatements);
        HiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata hiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata = new HiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata(aEStatements, this.getContext(), this.getLog(), this.m_settings, this.m_hiveClient, this.m_statement, this.m_connection, this.m_originalAEStatment, this.m_originalDataContext, this.m_isDirectExecuteQuery, this.m_requestMap);
        hiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata.prepareResults();
        return hiveJDBCQueryExecutorWithLimitZeroPreparedStatementMetadata;
    }
}

