/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.core.utilities.Variant;
import com.cloudera.impala.dsi.dataengine.impl.DSIEmptyResultSet;
import com.cloudera.impala.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.cloudera.impala.dsi.dataengine.interfaces.IQueryExecutor;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionResults;
import com.cloudera.impala.dsi.dataengine.utilities.Nullable;
import com.cloudera.impala.dsi.dataengine.utilities.ParameterInputValue;
import com.cloudera.impala.dsi.dataengine.utilities.ParameterMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.ParameterType;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.dsi.exceptions.BadDefaultParamException;
import com.cloudera.impala.dsi.exceptions.ExecutingException;
import com.cloudera.impala.dsi.exceptions.OperationCanceledException;
import com.cloudera.impala.dsi.exceptions.ParsingException;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.HiveExecutionContext;
import com.cloudera.impala.hivecommon.api.IExecutorUtility;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.core.HiveJDBCStatement;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCLimitChecker;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCLimitZeroPreparedStatementMetadataUtils;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCQueryAnalyserUtils;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.querytranslation.IQueryGenerator;
import com.cloudera.impala.hivecommon.utils.HiveCommonQueryTranslationUtils;
import com.cloudera.impala.jdbc.utils.ParseQueryUtils;
import com.cloudera.impala.jdbc42.internal.apache.commons.codec.binary.Base64;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOperationHandle;
import com.cloudera.impala.sqlengine.SQLEngineGenericContext;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlQueryExecutorContext;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineException;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.parser.DefaultLimitChecker;
import com.cloudera.impala.sqlengine.parser.IPTLimitChecker;
import com.cloudera.impala.sqlengine.parser.PTParser;
import com.cloudera.impala.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HiveJDBCNativeQueryExecutor
implements IQueryExecutor,
IExecutorUtility {
    private static final Pattern SET_DESCR_VALUE = Pattern.compile("(?i)set[^=]*$");
    private ILogger m_logger;
    private ExecutionResults m_results = new ExecutionResults();
    private IHiveClient m_client;
    private HiveJDBCStatement m_statement;
    private String m_nativeQuery;
    private HiveExecutionContext m_context;
    private HiveExecutionContext m_prepareLimitZeroMetadataQueryContext;
    private HiveJDBCCommonConnection m_connection;
    private HiveJDBCSettings m_settings;
    private boolean m_isRowCountQuery;
    private boolean m_isQueryTypeIdentified;
    private boolean m_isDirectExecuteQuery;
    private boolean m_isPrepareStage;
    private boolean m_isParamPrepareStage;
    private SqlQueryExecutorContext m_sqlqueryContext;
    private ConnSettingRequestMap m_requestMap;
    private int m_parameterCount = -2;
    ArrayList<ParameterMetadata> m_cachedParameterMetadata = new ArrayList();
    private ArrayList<ParameterMetadata> m_paramMetadataList;
    private IPTNode m_parseTreeRoot = null;
    private boolean m_upsertQuery = false;
    private boolean m_queryTranslationFailed = false;
    private boolean m_rowCountIsSet = false;
    public static final String DESCRIBE_CASE = "DESCRIBE";
    public static final String DESC_CASE = "DESC";
    public static final String EXPLAIN_CASE = "EXPLAIN";
    public static final String SELECT_CASE = "SELECT";
    public static final String SHOW_CASE = "SHOW";
    public static final String VALUES_UCASE = "VALUES";
    public static final String SET_CASE = "SET";
    public static final String SET_V_CASE = "SET -V";
    public static final String USE_CATALOG_CASE = "USE CATALOG";
    public static final String USE_CASE = "USE";
    public static final String WITH_CASE = "WITH";
    public static final String COMPUTE_CASE = "COMPUTE";
    public static final String FROM_CASE = "FROM";
    public static final String DROP_CASE = "DROP";
    public static final String ALTER_CASE = "ALTER";
    public static final String TRUNCATE_CASE = "TRUNCATE";
    public static final String ABORT_CASE = "ABORT";
    public static final String GRANT_CASE = "GRANT";
    public static final String LOAD_DATA_CASE = "LOAD DATA";
    public static final String INSERT_CASE = "INSERT";
    public static final String UPDATE_CASE = "UPDATE";
    public static final String DELETE_CASE = "DELETE";
    public static final String MERGE_CASE = "MERGE";
    public static final String UPSERT_CASE = "UPSERT";
    public static final String CACHE_CASE = "CACHE";
    public static final String CLEAR_CACHE_CASE = "CLEAR CACHE";
    public static final String COPY_INTO_CASE = "COPY INTO";
    public static final String CREATE_CASE = "CREATE";

    public HiveJDBCNativeQueryExecutor(ILogger iLogger, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement, HiveJDBCCommonConnection hiveJDBCCommonConnection, boolean bl, SqlQueryExecutorContext sqlQueryExecutorContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger, iHiveClient);
        this.m_logger = iLogger;
        this.m_client = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_connection = hiveJDBCCommonConnection;
        this.m_settings = hiveJDBCCommonConnection.getSettings();
        this.m_nativeQuery = null;
        this.m_isQueryTypeIdentified = false;
        this.m_isDirectExecuteQuery = bl;
        this.m_sqlqueryContext = sqlQueryExecutorContext;
        this.m_isParamPrepareStage = true;
    }

    public HiveJDBCNativeQueryExecutor(ILogger iLogger, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement, String string, HiveJDBCCommonConnection hiveJDBCCommonConnection, boolean bl, ConnSettingRequestMap connSettingRequestMap, boolean bl2, boolean bl3) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger, iHiveClient, string);
        this.m_logger = iLogger;
        this.m_client = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_connection = hiveJDBCCommonConnection;
        this.m_settings = hiveJDBCCommonConnection.getSettings();
        this.m_nativeQuery = this.m_settings.m_stripCatalogName ? HiveCommonQueryTranslationUtils.stripCatalogName(string, iLogger, this.m_settings, this.m_connection.getWarningListener()) : string;
        this.m_isQueryTypeIdentified = true;
        this.m_isDirectExecuteQuery = bl;
        this.m_isPrepareStage = true;
        this.m_requestMap = connSettingRequestMap;
        this.m_upsertQuery = bl2;
        this.m_parameterCount = CoreUtils.parameterCounter(this.m_nativeQuery);
        this.m_queryTranslationFailed = bl3;
        this.setIsRowCountResult(this.m_nativeQuery);
        if (0 < this.m_parameterCount) {
            this.m_isParamPrepareStage = true;
        }
        if (!this.isRowCountQuery()) {
            if (0 < this.m_parameterCount) {
                this.m_results = new ExecutionResults();
                this.m_results.addResultSet(new DSIEmptyResultSet());
            } else {
                this.executeQuery(this.m_nativeQuery);
                this.m_isPrepareStage = false;
            }
        } else {
            this.m_results.addRowCountResult(new DSISimpleRowCountResult(null == this.m_context ? -1L : this.m_context.m_rowCount));
        }
    }

    public HiveJDBCNativeQueryExecutor(ILogger iLogger, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement, String string, IPTNode iPTNode, HiveJDBCCommonConnection hiveJDBCCommonConnection, boolean bl, ConnSettingRequestMap connSettingRequestMap, boolean bl2, Boolean bl3) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger, iHiveClient, string);
        this.m_logger = iLogger;
        this.m_client = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_connection = hiveJDBCCommonConnection;
        this.m_settings = hiveJDBCCommonConnection.getSettings();
        this.m_nativeQuery = string;
        this.m_parseTreeRoot = iPTNode;
        this.m_isQueryTypeIdentified = true;
        this.m_isDirectExecuteQuery = bl;
        this.m_isPrepareStage = true;
        this.m_requestMap = connSettingRequestMap;
        this.m_isParamPrepareStage = bl2;
        this.m_upsertQuery = bl3;
        this.m_parameterCount = CoreUtils.parameterCounter(this.m_nativeQuery);
        this.setIsRowCountResult(this.m_nativeQuery);
        this.m_results.addRowCountResult(new DSISimpleRowCountResult(-1L));
    }

    @Override
    public void cancelExecute() {
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_statement.clearCancel();
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, ErrorException, OperationCanceledException {
        LogUtilities.logFunctionEntrance(this.m_logger, executionContexts, iWarningListener);
        if (this.m_settings.m_platformVersionUtils.needsInsertOptimization(this.m_settings.m_serverVersion) && !this.m_settings.m_useNativeQuery && this.m_settings.m_optimizedInsert && this.isRowCountQuery() && this.m_nativeQuery.toUpperCase(Locale.ENGLISH).startsWith(INSERT_CASE) && null != this.m_parseTreeRoot) {
            IQueryGenerator iQueryGenerator = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getQueryGenerator();
            String string = iQueryGenerator.generate(this.m_parseTreeRoot, this.m_settings, executionContexts);
            string = this.convertInsertToUpsert(string);
            if (0 < this.m_parameterCount) {
                this.executeRowCountQueryHelper(string);
            } else {
                try {
                    this.executeRowCountQueryHelper(string);
                }
                catch (ErrorException errorException) {
                    errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                    LogUtilities.logWarning(errorException, this.m_logger);
                    LogUtilities.logInfo("trying with native query", this.m_logger);
                    if (!this.m_settings.m_disableTranslatedToOriginalQueryFallback) {
                        this.executeRowCountQueryHelper(this.m_nativeQuery);
                    }
                    throw errorException;
                }
            }
            this.m_results.getResults().clear();
            this.m_results.addRowCountResult(new DSISimpleRowCountResult(this.m_context.m_rowCount));
        } else if (this.isRowCountQuery()) {
            block31: {
                String string = null;
                if (this.m_settings.m_platformVersionUtils.needsInsertOptimization(this.m_settings.m_serverVersion) && this.m_settings.m_useNativeQuery && this.m_nativeQuery.toUpperCase(Locale.ENGLISH).startsWith(INSERT_CASE)) {
                    try {
                        Object object;
                        if (null == this.m_parseTreeRoot) {
                            object = new HiveJDBCLimitChecker();
                            ((DefaultLimitChecker)object).initLimitCheckValues(this.m_statement.getParentConnection());
                            this.m_parseTreeRoot = PTParser.parse(this.m_nativeQuery, (IPTLimitChecker)object);
                        }
                        if (null == this.m_parseTreeRoot) {
                            throw SQLEngineExceptionFactory.invalidParseTreeException();
                        }
                        object = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getQueryGenerator();
                        string = object.generate(this.m_parseTreeRoot, this.m_settings, executionContexts);
                        this.executeRowCountQueryHelper(string);
                    }
                    catch (Exception exception) {
                        if (exception instanceof SQLEngineException) {
                            ErrorException errorException = (ErrorException)exception;
                            errorException.loadMessage(SQLEngineGenericContext.getDefaultMsgSource(), this.m_client.getWarningListener().getLocale());
                            LogUtilities.logWarning(exception, this.m_logger);
                        } else {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{exception.getMessage(), "HY000", string});
                            errorException.initCause(exception);
                            LogUtilities.logWarning(errorException, this.m_logger);
                        }
                        if (0 < this.m_parameterCount) {
                            this.executeHelperParameter(executionContexts);
                            break block31;
                        }
                        this.executeRowCountQueryHelper(this.m_nativeQuery);
                    }
                } else if (0 < this.m_parameterCount) {
                    this.executeHelperParameter(executionContexts);
                } else {
                    this.executeRowCountQueryHelper(this.m_nativeQuery);
                }
            }
            this.m_results.getResults().clear();
            this.m_results.addRowCountResult(new DSISimpleRowCountResult(this.m_context.m_rowCount));
        } else if (0 < this.m_parameterCount) {
            this.m_context = this.m_client.executeStatement(HiveJDBCNativeQueryExecutor.getQueryWithParametersPopulated(this.m_nativeQuery, executionContexts), this);
            if (this.m_context.m_isManualCanceled.get()) {
                this.m_client.closeOperation(this.m_context);
                this.m_context.m_isManualCanceled.set(false);
                throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
            }
            HiveJDBCResultSet hiveJDBCResultSet = new HiveJDBCResultSet(this.m_context, this.m_client, this.m_statement, this.m_connection, this.m_logger, this.isRowCountQuery(), this.m_queryTranslationFailed);
            hiveJDBCResultSet.openCursor();
            this.m_results.getResults().clear();
            this.m_results.addResultSet(hiveJDBCResultSet);
        } else if (this.m_settings.m_preparedStmtGetMetadataLimitZero && !this.m_isDirectExecuteQuery) {
            if (null != this.m_prepareLimitZeroMetadataQueryContext) {
                this.m_client.closeOperation(this.m_prepareLimitZeroMetadataQueryContext);
                this.m_context = this.m_client.executeStatement(this.m_nativeQuery, this);
            } else if (!this.m_context.m_isLimitZeroQueryParseFailed) {
                this.m_context = this.m_client.executeStatement(this.m_nativeQuery, this);
            }
            if (this.m_context.m_isManualCanceled.get()) {
                this.m_client.closeOperation(this.m_context);
                this.m_context.m_isManualCanceled.set(false);
                throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
            }
            HiveJDBCResultSet hiveJDBCResultSet = new HiveJDBCResultSet(this.m_context, this.m_client, this.m_statement, this.m_connection, this.m_logger, this.isRowCountQuery(), this.m_queryTranslationFailed);
            hiveJDBCResultSet.openCursor();
            this.m_results.getResults().clear();
            this.m_results.addResultSet(hiveJDBCResultSet);
        } else {
            HiveJDBCResultSet hiveJDBCResultSet = (HiveJDBCResultSet)this.m_results.getResults().get(0).getResult();
            if (null != this.m_prepareLimitZeroMetadataQueryContext && this.m_prepareLimitZeroMetadataQueryContext.m_isManualCanceled.get()) {
                this.m_client.closeOperation(this.m_context);
                this.m_context.m_isManualCanceled.set(false);
                throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
            }
            if (!hiveJDBCResultSet.hasOpenCursor()) {
                this.executeQuery(this.m_nativeQuery);
            }
        }
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_cachedParameterMetadata && this.m_parameterCount == -2) {
            return this.m_cachedParameterMetadata;
        }
        if (this.m_parameterCount > 0) {
            if (this.m_isParamPrepareStage) {
                this.m_paramMetadataList = new ArrayList();
                for (int i = 0; i < this.m_parameterCount; ++i) {
                    ParameterMetadata parameterMetadata = new ParameterMetadata(i, ParameterType.INPUT, 12);
                    this.m_paramMetadataList.add(parameterMetadata);
                }
                this.m_isParamPrepareStage = false;
            }
            return this.m_paramMetadataList;
        }
        return new ArrayList<ParameterMetadata>();
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_parameterCount >= 0) {
            return this.m_parameterCount;
        }
        return 0;
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_results) {
            this.m_results = new ExecutionResults();
            this.executeQuery(this.m_nativeQuery);
        }
        return this.m_results;
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        if (this.m_parameterCount > 0) {
            this.m_paramMetadataList.clear();
            if (null == map) {
                for (int i = 0; i < this.m_parameterCount; ++i) {
                    ParameterMetadata parameterMetadata = new ParameterMetadata(i + 1, ParameterType.INPUT, 12);
                    this.m_paramMetadataList.add(parameterMetadata);
                }
                return;
            }
            for (int i = 0; i < this.m_parameterCount; ++i) {
                int n;
                TypeMetadata typeMetadata = map.get(i);
                ParameterMetadata parameterMetadata = null;
                if (null == typeMetadata) {
                    n = 12;
                    parameterMetadata = new ParameterMetadata(i + 1, ParameterType.INPUT, n);
                } else {
                    n = map.get(i).getType();
                    parameterMetadata = new ParameterMetadata(i + 1, ParameterType.INPUT, typeMetadata, 0L, null, false, Nullable.NULLABLE);
                }
                this.m_paramMetadataList.add(parameterMetadata);
            }
        }
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, parameterInputValue);
    }

    public void executeQuery(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        String string2 = string;
        if (this.m_settings.m_preparedStmtGetMetadataLimitZero && !this.m_isDirectExecuteQuery && this.m_isPrepareStage) {
            string2 = HiveJDBCLimitZeroPreparedStatementMetadataUtils.nativeLimitZeroQueryBuilder(string2, this.m_client, this.m_settings);
        }
        try {
            this.setIsRowCountResult(string2);
            if (this.isRowCountQuery()) {
                this.executeRowCountQueryHelper(string2);
            } else {
                this.executeNonRowCountQueryHelper(string2);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw operationCanceledException;
        }
        catch (ErrorException errorException) {
            CoreUtils.postWarning(errorException, this.m_client.getWarningListener(), WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name(), this.m_logger, this.m_settings.m_suppressWarningsAsDebugLog);
            if (this.m_settings.m_preparedStmtGetMetadataLimitZero && !this.m_isDirectExecuteQuery && this.m_isPrepareStage) {
                this.m_context = this.m_client.executeStatement(string, this);
                this.m_context.m_isLimitZeroQueryParseFailed = true;
            }
            throw errorException;
        }
        if (this.m_context.m_isManualCanceled.get()) {
            this.m_client.closeOperation(this.m_context);
            this.m_context.m_isManualCanceled.set(false);
            throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
        }
        if (!this.m_isQueryTypeIdentified) {
            this.setIsRowCountResult(string2);
            this.m_isQueryTypeIdentified = true;
        }
        this.m_results.getResults().clear();
        if (!this.isRowCountQuery()) {
            HiveJDBCResultSet hiveJDBCResultSet = null;
            hiveJDBCResultSet = this.m_settings.m_preparedStmtGetMetadataLimitZero && !this.m_context.m_isLimitZeroQueryParseFailed ? new HiveJDBCResultSet(this.m_prepareLimitZeroMetadataQueryContext, this.m_client, this.m_statement, this.m_connection, this.m_logger, this.isRowCountQuery(), this.m_queryTranslationFailed) : new HiveJDBCResultSet(this.m_context, this.m_client, this.m_statement, this.m_connection, this.m_logger, this.isRowCountQuery(), this.m_queryTranslationFailed);
            hiveJDBCResultSet.openCursor();
            this.m_results.addResultSet(hiveJDBCResultSet);
        } else {
            this.m_results.addRowCountResult(new DSISimpleRowCountResult(this.m_context.m_rowCount));
        }
    }

    public void setParameterMetadataForPrepareStatement(ArrayList<ParameterMetadata> arrayList) {
        this.m_cachedParameterMetadata = arrayList;
    }

    @Override
    public HiveExecutionContext getExeContext() {
        if (null != this.m_context) {
            if (null != this.m_context.m_executeResponse) {
                return this.m_context;
            }
            return null;
        }
        return null;
    }

    @Override
    public HiveJDBCStatement getStatement() {
        return this.m_statement;
    }

    @Override
    public void setExeContext(HiveExecutionContext hiveExecutionContext) {
        this.m_context = hiveExecutionContext;
    }

    @Override
    public int getQueryTimeout() throws Exception {
        int n = 0;
        Variant variant = this.m_statement.getProperty(3);
        n = variant.getInt() * 1000;
        return n;
    }

    public String getYarnATSGuid() {
        if (null != this.m_context) {
            TExecuteStatementResp tExecuteStatementResp = this.m_context.m_executeResponse;
            TOperationHandle tOperationHandle = tExecuteStatementResp.getOperationHandle();
            String string = new String(Base64.encodeBase64(tOperationHandle.getOperationId().getGuid()));
            string = string.replace("=", "").replace("+", "-").replace("/", "_");
            return string;
        }
        return null;
    }

    public boolean isRowCountQuery() {
        return this.m_isRowCountQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNonRowCountQueryHelper(String string) throws ErrorException {
        if (this.m_settings.m_hiveAsyncQueryTest) {
            this.m_statement.setAsyncExecution(true);
        }
        if (HiveJDBCQueryAnalyserUtils.isSetDatabricksCatalogStatement(string)) {
            String string2 = HiveJDBCQueryAnalyserUtils.analyzeSetDatabricksCatalogStatement(string);
            IHiveClient iHiveClient = this.m_client;
            synchronized (iHiveClient) {
                this.m_context = this.m_client.executeStatement(string, this);
                if (this.m_settings.m_trackCatalogFromQueries && null != string2) {
                    HiveJDBCSettings hiveJDBCSettings = this.m_settings;
                    synchronized (hiveJDBCSettings) {
                        this.m_settings.m_catalog = string2;
                    }
                }
            }
        }
        this.m_context = this.m_client.executeStatement(string, this);
        if (this.m_settings.m_preparedStmtGetMetadataLimitZero) {
            this.m_prepareLimitZeroMetadataQueryContext = this.m_context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRowCountQueryHelper(String string) throws ErrorException {
        if (HiveJDBCQueryAnalyserUtils.isUseCatalogStatement(string = this.convertInsertToUpsert(string))) {
            String string2 = HiveJDBCQueryAnalyserUtils.analyzeUseCatalogStatement(string);
            IHiveClient iHiveClient = this.m_client;
            synchronized (iHiveClient) {
                this.m_context = this.m_client.executeStatement(string, this);
                if (this.m_settings.m_trackCatalogFromQueries && null != string2) {
                    HiveJDBCSettings hiveJDBCSettings = this.m_settings;
                    synchronized (hiveJDBCSettings) {
                        this.m_settings.m_catalog = string2;
                    }
                }
            }
        }
        if (HiveJDBCQueryAnalyserUtils.isSetDatabricksCatalogStatement(string)) {
            String string3 = HiveJDBCQueryAnalyserUtils.analyzeSetDatabricksCatalogStatement(string);
            IHiveClient iHiveClient = this.m_client;
            synchronized (iHiveClient) {
                this.m_context = this.m_client.executeStatement(string, this);
                if (this.m_settings.m_trackCatalogFromQueries && null != string3) {
                    HiveJDBCSettings hiveJDBCSettings = this.m_settings;
                    synchronized (hiveJDBCSettings) {
                        this.m_settings.m_catalog = string3;
                    }
                }
            }
        }
        if (HiveJDBCQueryAnalyserUtils.isUseStatement(string)) {
            String string4 = HiveJDBCQueryAnalyserUtils.analyzeUseStatement(string);
            IHiveClient iHiveClient = this.m_client;
            synchronized (iHiveClient) {
                this.m_context = this.m_client.executeStatement(string, this);
                if (null != string4) {
                    HiveJDBCSettings hiveJDBCSettings = this.m_settings;
                    synchronized (hiveJDBCSettings) {
                        this.m_settings.m_Schema = string4;
                    }
                }
            }
        }
        this.m_context = this.m_client.executeStatement(string, this);
        this.m_client.closeOperation(this.m_context);
    }

    private void executeHelperParameter(ExecutionContexts executionContexts) throws ErrorException {
        this.m_nativeQuery = this.convertInsertToUpsert(this.m_nativeQuery);
        if (this.m_nativeQuery.startsWith(UPDATE_CASE)) {
            List<String> list = this.getUpdateQueriesWithParametersPopulated(this.m_nativeQuery, executionContexts);
            for (String string : list) {
                this.executeRowCountQueryHelper(string);
            }
        } else if (this.m_nativeQuery.toUpperCase(Locale.ENGLISH).startsWith(INSERT_CASE) || this.m_nativeQuery.toUpperCase(Locale.ENGLISH).startsWith(UPSERT_CASE)) {
            this.executeRowCountQueryHelper(this.getInsertQueryWithParametersPopulated(this.m_nativeQuery, executionContexts));
        } else {
            this.executeRowCountQueryHelper(HiveJDBCNativeQueryExecutor.getQueryWithParametersPopulated(this.m_nativeQuery, executionContexts));
        }
    }

    private String getInsertQueryWithParametersPopulated(String string, ExecutionContexts executionContexts) throws ErrorException {
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        return CoreUtils.buildInsertQueryWithParameters(string, iterator);
    }

    private List<String> getUpdateQueriesWithParametersPopulated(String string, ExecutionContexts executionContexts) throws ErrorException {
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        return CoreUtils.buildUpdateQueryWithParameters(string, iterator);
    }

    private static String getQueryWithParametersPopulated(String string, ExecutionContexts executionContexts) throws ErrorException {
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        String string2 = CoreUtils.buildQueryWithParameters(string, iterator);
        if (iterator.hasNext()) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_BATCH_ERR.name());
            throw errorException;
        }
        return string2;
    }

    private void setIsRowCountResult(String string) {
        char c;
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        if (this.m_rowCountIsSet) {
            return;
        }
        this.m_rowCountIsSet = true;
        String string2 = ParseQueryUtils.parseCommentsOnSingleQuery(string.trim()).toUpperCase();
        string2 = string2.trim();
        int n = 0;
        if (string2.startsWith(WITH_CASE)) {
            if (this.m_settings.m_cteQueryResultSet) {
                this.m_isRowCountQuery = false;
                return;
            }
            string2 = HiveJDBCQueryAnalyserUtils.removeWithExpression(string2);
        }
        for (int i = 0; i < string2.length() && ('(' == (c = string2.charAt(i)) || Character.isWhitespace(c)); ++i) {
            ++n;
        }
        for (String string3 : this.m_settings.m_nonRowcountQueryPrefixes) {
            if (!string2.startsWith(string3)) continue;
            this.m_isRowCountQuery = false;
            return;
        }
        if (string2.startsWith(DROP_CASE) || string2.startsWith(ALTER_CASE) || string2.startsWith(CREATE_CASE) || string2.startsWith(USE_CASE) || string2.startsWith(TRUNCATE_CASE) || string2.startsWith(ABORT_CASE) || string2.startsWith(GRANT_CASE) || string2.startsWith(LOAD_DATA_CASE) || string2.startsWith(INSERT_CASE) || string2.startsWith(UPDATE_CASE) || string2.startsWith(DELETE_CASE) || string2.startsWith(MERGE_CASE) || string2.startsWith(UPSERT_CASE) || string2.startsWith(CACHE_CASE) || string2.startsWith(CLEAR_CACHE_CASE) || string2.startsWith(COPY_INTO_CASE)) {
            this.m_isRowCountQuery = true;
            return;
        }
        Matcher matcher = SET_DESCR_VALUE.matcher(string);
        if (string2.isEmpty() || string2.startsWith(SELECT_CASE, n) || string2.startsWith(DESCRIBE_CASE) || string2.startsWith(EXPLAIN_CASE) || string2.startsWith(SHOW_CASE, n) || string2.startsWith(VALUES_UCASE) || string2.equals(SET_CASE) || string2.equals(SET_V_CASE) || this.m_settings.m_setKeyValueQueryResultSet && string2.startsWith(SET_CASE) || string2.startsWith(DESC_CASE) || string2.startsWith(COMPUTE_CASE) || string2.startsWith(FROM_CASE) || matcher.matches()) {
            this.m_isRowCountQuery = false;
            return;
        }
        this.m_isRowCountQuery = HiveJDBCStatement.ExecuteMethodType.EXECUTE_UPDATE == this.m_statement.getExecuteType() ? true : (HiveJDBCStatement.ExecuteMethodType.EXECUTE_QUERY == this.m_statement.getExecuteType() ? false : !this.m_settings.m_unrecognizedStmtReturnsQueryResult);
    }

    private String convertInsertToUpsert(String string) {
        if (this.m_upsertQuery) {
            return string.replaceFirst("(?i)INSERT", UPSERT_CASE);
        }
        return string;
    }
}

