/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HiveJDBCQueryAnalyserUtils {
    private static final String WITH_CASE = "WITH";
    private static final String SET_DATABRICKS_CATALOG_PATTERN = "\\s*SET\\s+" + "databricks.catalog".toUpperCase().replace(".", "\\.") + "\\s*=\\s*(.+)";
    private static final String USE_SCHEMA_STATEMENT_PATTERN = "\\s*USE(?:(?=`)|\\s+)(.+)";
    private static final String USE_CATALOG_STATEMENT_PATTERN = "\\s*USE\\s+CATALOG(?:(?=`)|\\s+)(.+)";
    private static final int AS_CLAUSE_NOT_FOUND = -1;

    public static String queryAnalysis(String string) {
        String string2 = "DESCRIBE";
        String string3 = "SELECT";
        String[] stringArray = string.split(" ");
        if (stringArray[0].toUpperCase().equals(string2)) {
            return string2;
        }
        if (stringArray[0].toUpperCase().equals(string3)) {
            return string3;
        }
        return "Type not found";
    }

    public static String analyzeSetDatabricksCatalogStatement(String string) {
        Matcher matcher = Pattern.compile(SET_DATABRICKS_CATALOG_PATTERN, 34).matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        return HiveJDBCQueryAnalyserUtils.analyzeIdentifier(string2);
    }

    public static String analyzeUseCatalogStatement(String string) {
        Matcher matcher = Pattern.compile(USE_CATALOG_STATEMENT_PATTERN, 34).matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        return HiveJDBCQueryAnalyserUtils.analyzeIdentifier(string2);
    }

    public static String analyzeUseStatement(String string) {
        Matcher matcher = Pattern.compile(USE_SCHEMA_STATEMENT_PATTERN, 34).matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        return HiveJDBCQueryAnalyserUtils.analyzeIdentifier(string2);
    }

    public static String analyzeIdentifier(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.startsWith("`")) {
            int n = 1;
            while (n < string.length()) {
                char c = string.charAt(n);
                if ('`' == c) {
                    if (string.length() <= n + 1 || '`' != string.charAt(n + 1)) break;
                    stringBuilder.append(c);
                    n += 2;
                    continue;
                }
                stringBuilder.append(c);
                ++n;
            }
            if (2 <= stringBuilder.length() && '`' == stringBuilder.charAt(0) && '`' == stringBuilder.charAt(stringBuilder.length() - 1)) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.deleteCharAt(0);
            }
        } else {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    assert (0 != i);
                    break;
                }
                stringBuilder.append(c);
            }
        }
        return stringBuilder.toString();
    }

    public static boolean isSetDatabricksCatalogStatement(String string) {
        Matcher matcher = Pattern.compile(SET_DATABRICKS_CATALOG_PATTERN, 34).matcher(string);
        return matcher.matches();
    }

    public static boolean isUseCatalogStatement(String string) {
        Matcher matcher = Pattern.compile(USE_CATALOG_STATEMENT_PATTERN, 34).matcher(string);
        return matcher.matches();
    }

    public static boolean isUseStatement(String string) {
        Matcher matcher = Pattern.compile(USE_SCHEMA_STATEMENT_PATTERN, 34).matcher(string);
        return matcher.matches();
    }

    public static String removeWithExpression(String string) {
        if (!string.startsWith(WITH_CASE)) {
            return string;
        }
        string = string.substring(WITH_CASE.length());
        int n = 0;
        int n2 = 0;
        ParseState parseState = ParseState.INITIAL;
        int n3 = 0;
        block18: for (int i = 0; i < string.length(); ++i) {
            switch (parseState) {
                case INITIAL: {
                    int n4;
                    int n5 = string.charAt(i);
                    switch (n5) {
                        case 40: {
                            ++n;
                            break;
                        }
                        case 41: {
                            if (0 != --n) break;
                            parseState = ParseState.AFTER_SUBQ;
                            break;
                        }
                        case 34: 
                        case 39: 
                        case 96: {
                            n3 = n5;
                            parseState = ParseState.QUOTE;
                            break;
                        }
                        case 91: {
                            n3 = 93;
                            parseState = ParseState.QUOTE;
                            break;
                        }
                        case 65: 
                        case 97: {
                            if (0 != n) break;
                            n4 = HiveJDBCQueryAnalyserUtils.isAsClausePresent(string, i);
                            if (-1 == n4) continue block18;
                            parseState = ParseState.AS_CLAUSE;
                            i = n4 - 1;
                            break;
                        }
                    }
                    continue block18;
                }
                case AS_CLAUSE: {
                    int n5 = string.charAt(i);
                    switch (n5) {
                        case 40: {
                            ++n2;
                            continue block18;
                        }
                        case 41: {
                            if (0 != --n2) continue block18;
                            parseState = ParseState.AFTER_AS_CLAUSE;
                            continue block18;
                        }
                    }
                    continue block18;
                }
                case AFTER_AS_CLAUSE: {
                    int n5 = string.charAt(i);
                    if (Character.isWhitespace((char)n5)) {
                        parseState = ParseState.AFTER_AS_CLAUSE;
                        continue block18;
                    }
                    if (44 == n5) {
                        parseState = ParseState.INITIAL;
                        continue block18;
                    }
                    return string.substring(i);
                }
                case QUOTE: {
                    int n5;
                    while (i < string.length()) {
                        n5 = string.charAt(i);
                        if (92 == n5) {
                            ++i;
                        } else if (n3 == n5) {
                            parseState = ParseState.INITIAL;
                            continue block18;
                        }
                        ++i;
                    }
                    continue block18;
                }
                case AFTER_SUBQ: {
                    int n5 = string.charAt(i);
                    if (Character.isWhitespace((char)n5)) {
                        parseState = ParseState.AFTER_SUBQ;
                        continue block18;
                    }
                    if (97 != n5 && 65 != n5) continue block18;
                    int n4 = HiveJDBCQueryAnalyserUtils.isAsClausePresent(string, i);
                    if (-1 != n4) {
                        parseState = ParseState.AS_CLAUSE;
                        i = n4 - 1;
                        continue block18;
                    }
                    return "";
                }
            }
        }
        return "";
    }

    private static int isAsClausePresent(String string, int n) {
        char c;
        char c2 = string.charAt(n - 1);
        if (!(' ' != c2 && ')' != c2 && '`' != c2 && '\"' != c2 || 's' != (c = string.charAt(++n)) && 'S' != c)) {
            while (Character.isWhitespace(string.charAt(++n))) {
            }
            if ('(' == string.charAt(n)) {
                return n;
            }
        }
        return -1;
    }

    private static enum ParseState {
        INITIAL,
        QUOTE,
        AFTER_SUBQ,
        AS_CLAUSE,
        AFTER_AS_CLAUSE;

    }
}

