/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.core;

import com.cloudera.impala.dsi.core.interfaces.IEnvironment;
import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.core.utilities.Variant;
import com.cloudera.impala.dsi.exceptions.BadAuthException;
import com.cloudera.impala.jdbc.core.DSCommonConnection;
import com.cloudera.impala.jdbc.core.DSDriver;
import com.cloudera.impala.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.DiagState;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.sql.DriverManager;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class LoginTimeoutConnection
extends DSCommonConnection {
    public static final int LOGIN_TIMEOUT_DISABLED = 0;

    protected LoginTimeoutConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connect(final ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        int n;
        int n2;
        block14: {
            n2 = this.getLoginTimeOut();
            Variant variant = this.getOptionalSetting("LoginTimeout", connSettingRequestMap);
            if (null != variant) {
                try {
                    n2 = variant.getInt();
                }
                catch (Exception exception) {
                    if (null == this.getWarningListener()) break block14;
                    LogUtilities.logDebug("Error when reading loginTimeout value: \"" + variant.getString() + "\" from connection string.", this.getConnectionLog());
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{variant.getString(), "Integers"}));
                }
            }
        }
        if (0 < (n = n2)) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<Boolean> future = null;
            try {
                future = executorService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws ErrorException {
                        LogUtilities.logDebug("establishConnection() in a new thread: " + Thread.currentThread().getId(), LoginTimeoutConnection.this.getConnectionLog());
                        LoginTimeoutConnection.this.establishConnection(connSettingRequestMap, n);
                        return true;
                    }
                });
                future.get(n, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                future.cancel(true);
                this.handleException(timeoutException);
            }
            catch (ExecutionException executionException) {
                future.cancel(true);
                this.handleException(executionException);
            }
            catch (Exception exception) {
                future.cancel(true);
                this.handleException(exception);
            }
            finally {
                executorService.shutdown();
            }
        } else {
            this.establishConnection(connSettingRequestMap, 0);
        }
    }

    protected abstract void establishConnection(ConnSettingRequestMap var1, int var2) throws ErrorException, BadAuthException;

    protected void handleException(Exception exception) throws ErrorException {
        if (null != exception && exception instanceof TimeoutException) {
            throw new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{"None"});
        }
        if (null != exception) {
            if (exception instanceof RejectedExecutionException || exception instanceof NullPointerException || exception instanceof InterruptedException || exception instanceof CancellationException) {
                String string = exception.getMessage();
                if (null == string) {
                    string = "None";
                }
                throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_THREAD_EXCEPTION.name(), new String[]{exception.getClass().getName(), string});
            }
            Throwable throwable = exception.getCause();
            if (null != throwable && throwable instanceof ErrorException) {
                throw (ErrorException)throwable;
            }
            if (null != exception.getMessage()) {
                throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_UNEXP_SESSION_ERR.name(), exception.getMessage());
            }
        }
        throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_UNEXP_SESSION_ERR.name(), "Unknown");
    }

    private int getLoginTimeOut() {
        return DriverManager.getLoginTimeout();
    }
}

