/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.bool;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.executor.etree.ETBoolean;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.IETNode;
import com.cloudera.impala.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.cloudera.impala.sqlengine.executor.etree.bool.functor.comp.IBooleanCompFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.impala.support.exceptions.ErrorException;

public class ETComparison
extends ETBooleanExpr {
    private ETValueExpr m_leftOperand;
    private ETValueExpr m_rightOperand;
    private IBooleanCompFunctor m_functor;
    private ETDataRequest m_leftData;
    private ETDataRequest m_rightData;

    public ETComparison(IColumn iColumn, ETValueExpr eTValueExpr, ETValueExpr eTValueExpr2, IBooleanCompFunctor iBooleanCompFunctor) throws ErrorException {
        if (eTValueExpr == null || iColumn == null || eTValueExpr2 == null || iBooleanCompFunctor == null) {
            throw new NullPointerException("ETArithmeticValueExpr does not take null input.");
        }
        this.m_leftData = new ETDataRequest(iColumn);
        this.m_rightData = new ETDataRequest(iColumn);
        this.m_leftOperand = eTValueExpr;
        this.m_rightOperand = eTValueExpr2;
        this.m_functor = iBooleanCompFunctor;
    }

    @Override
    public void close(boolean bl) {
        this.m_leftOperand.close(bl);
        this.m_rightOperand.close(bl);
    }

    @Override
    public boolean isOpen() {
        return this.m_leftOperand.isOpen() && this.m_rightOperand.isOpen();
    }

    @Override
    public void reset() throws ErrorException {
        this.m_leftOperand.reset();
        this.m_rightOperand.reset();
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public ETBoolean evaluate() throws ErrorException {
        this.m_leftOperand.retrieveData(this.m_leftData);
        this.m_rightOperand.retrieveData(this.m_rightData);
        return this.m_functor.evaluate(this.m_leftData.getData(), this.m_rightData.getData());
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.m_leftOperand;
            }
            case 1: {
                return this.m_rightOperand;
            }
        }
        throw new IndexOutOfBoundsException("index: " + n);
    }

    @Override
    public void open() throws ErrorException {
        this.m_leftOperand.open();
        this.m_rightOperand.open();
    }
}

