/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.relation.join;

import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.IJoinAlgorithmAdapter;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.IJoinUnit;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.IMasterJoinUnit;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.ISlaveJoinUnit;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.Pair;
import com.cloudera.impala.support.exceptions.ErrorException;

abstract class AbstractJoinAlgorithmAdaper
implements IJoinAlgorithmAdapter {
    protected boolean m_masterMatch;
    protected boolean m_outputMasterOuter;
    protected boolean m_outputSlaveOuter;
    protected AEJoin.AEJoinType m_joinType;
    protected boolean m_canReopenAfterClosed;
    private ISlaveJoinUnit m_slaveUnit;
    private IMasterJoinUnit m_masterJoinUnit;
    private boolean m_isMasterOnLeft;

    protected AbstractJoinAlgorithmAdaper(AEJoin.AEJoinType aEJoinType) {
        this.m_joinType = aEJoinType;
        this.m_outputMasterOuter = false;
        this.m_outputSlaveOuter = false;
        this.m_masterMatch = true;
    }

    @Override
    public void match() throws ErrorException {
        this.m_masterMatch = true;
        this.m_slaveUnit.match();
        this.m_masterJoinUnit.match();
    }

    @Override
    public boolean isOuterRow() {
        return this.m_outputMasterOuter || this.m_outputSlaveOuter;
    }

    @Override
    public boolean moveMaster() throws ErrorException {
        boolean bl;
        this.m_outputMasterOuter = false;
        if (this.m_masterMatch || !this.shouldOutputMasterOuter()) {
            bl = this.m_masterJoinUnit.moveToNextRow();
        } else {
            bl = this.moveMasterUnmatch();
            this.m_masterJoinUnit.processUnmatchedOuterRow();
            this.m_masterMatch = true;
        }
        if (bl) {
            return true;
        }
        if (this.shouldOutputSlaveOuter() && this.m_slaveUnit.hasOuterRows()) {
            this.m_outputSlaveOuter = true;
            this.m_slaveUnit.setOutputOuter();
            return false;
        }
        return false;
    }

    @Override
    public boolean moveSlave() throws ErrorException {
        if (this.m_outputSlaveOuter) {
            return this.m_slaveUnit.moveOuter();
        }
        return this.m_slaveUnit.moveToNextRow();
    }

    @Override
    public void seekSlave() {
        this.m_masterMatch = false;
        this.m_slaveUnit.seek(this.m_masterJoinUnit.getRow());
    }

    @Override
    public Pair<? extends IJoinUnit, ? extends IJoinUnit> loadNextJoinUnit() throws ErrorException {
        this.m_masterMatch = true;
        this.m_outputMasterOuter = false;
        this.m_outputSlaveOuter = false;
        Pair<ISlaveJoinUnit, IMasterJoinUnit> pair = this.loadMasterSlave();
        if (pair == null) {
            return null;
        }
        this.m_masterJoinUnit = pair.value();
        this.m_slaveUnit = pair.key();
        this.m_isMasterOnLeft = this.isMasterJoinUnitOnLeft();
        if (!this.isMasterJoinUnitOnLeft()) {
            return pair;
        }
        return new Pair<IMasterJoinUnit, ISlaveJoinUnit>(pair.value(), pair.key());
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
    }

    public abstract Pair<ISlaveJoinUnit, IMasterJoinUnit> loadMasterSlave() throws ErrorException;

    public boolean moveMasterUnmatch() throws ErrorException {
        this.m_outputMasterOuter = true;
        return true;
    }

    @Override
    public void setCanReopenAfterClosed() {
        this.m_canReopenAfterClosed = true;
    }

    private boolean shouldOutputMasterOuter() {
        return !(this.m_joinType == AEJoin.AEJoinType.INNER_JOIN || this.m_joinType == AEJoin.AEJoinType.LEFT_OUTER_JOIN && !this.m_isMasterOnLeft || this.m_joinType == AEJoin.AEJoinType.RIGHT_OUTER_JOIN && this.m_isMasterOnLeft);
    }

    private boolean shouldOutputSlaveOuter() {
        return !(this.m_joinType == AEJoin.AEJoinType.INNER_JOIN || this.m_joinType == AEJoin.AEJoinType.LEFT_OUTER_JOIN && this.m_isMasterOnLeft || this.m_joinType == AEJoin.AEJoinType.RIGHT_OUTER_JOIN && !this.m_isMasterOnLeft);
    }
}

