/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.DataInput;
import java.io.IOException;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.AbstractPacketReader;
import org.activemq.message.Packet;
import org.activemq.message.WireFormatInfo;

public class WireFormatInfoReader
extends AbstractPacketReader {
    AbstractDefaultWireFormat wireFormat;

    WireFormatInfoReader() {
    }

    WireFormatInfoReader(AbstractDefaultWireFormat format) {
        this.wireFormat = format;
    }

    public int getPacketType() {
        return 29;
    }

    public Packet createPacket() {
        return new WireFormatInfo();
    }

    public void buildPacket(Packet packet, DataInput dataIn) throws IOException {
        for (int i = 0; i < WireFormatInfo.MAGIC.length; ++i) {
            if (dataIn.readByte() == WireFormatInfo.MAGIC[i]) continue;
            throw new IOException("Invalid WireFormatInfo packet.");
        }
        super.buildPacket(packet, dataIn);
        WireFormatInfo info = (WireFormatInfo)packet;
        info.setVersion(dataIn.readInt());
        if (this.wireFormat != null) {
            this.wireFormat.setCurrentWireFormatVersion(info.getVersion());
        }
    }
}

