/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.activemq.io.util.MemoryBoundedQueue;
import org.activemq.io.util.MemoryBoundedQueueManager;
import org.activemq.io.util.MemoryManageable;
import org.activemq.service.QueueListEntry;
import org.activemq.service.impl.DefaultQueueList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryBoundedPrioritizedQueue
extends MemoryBoundedQueue {
    private static final Log log = LogFactory.getLog((Class)MemoryBoundedPrioritizedQueue.class);
    private static final int DEFAULT_PRIORITY = 4;
    private final DefaultQueueList[] prioritizedPackets = new DefaultQueueList[10];

    public MemoryBoundedPrioritizedQueue(MemoryBoundedQueueManager manager, String name) {
        super(manager, name);
        for (int i = 0; i < 10; ++i) {
            this.prioritizedPackets[i] = new DefaultQueueList();
        }
    }

    public int size() {
        int size = 0;
        for (int j = 0; j < 10; ++j) {
            size += this.prioritizedPackets[j].size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueNoBlock(MemoryManageable packet) {
        if (!this.closed) {
            this.prioritizedPackets[this.getPacketPriority(packet)].add(packet);
            this.incrementMemoryUsed(packet);
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueFirstNoBlock(MemoryManageable packet) {
        if (!this.closed) {
            this.prioritizedPackets[this.getPacketPriority(packet)].addFirst(packet);
            this.incrementMemoryUsed(packet);
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueAllFirstNoBlock(List packets) {
        if (!this.closed) {
            Iterator iterator = packets.iterator();
            Iterator iter = packets.iterator();
            while (iter.hasNext()) {
                MemoryManageable packet = (MemoryManageable)iter.next();
                this.prioritizedPackets[this.getPacketPriority(packet)].addFirst(packet);
                this.incrementMemoryUsed(packet);
            }
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryManageable dequeue() throws InterruptedException {
        MemoryManageable result = null;
        Object object = this.outLock;
        synchronized (object) {
            while (this.isEmpty() && !this.closed) {
                this.outLock.wait(100L);
            }
            result = this.dequeueNoWait();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryManageable dequeueNoWait() throws InterruptedException {
        MemoryManageable packet = null;
        Object object = this.outLock;
        synchronized (object) {
            while (this.stopped && !this.closed) {
                this.outLock.wait(100L);
            }
        }
        for (int i = 9; i >= 0 && (packet = (MemoryManageable)this.prioritizedPackets[i].removeFirst()) == null; --i) {
        }
        this.decrementMemoryUsed(packet);
        if (packet != null) {
            Object object2 = this.inLock;
            synchronized (object2) {
                this.inLock.notify();
            }
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(MemoryManageable packet) {
        boolean result = false;
        if (!this.isEmpty()) {
            result = this.prioritizedPackets[this.getPacketPriority(packet)].remove(packet);
        }
        if (result) {
            this.decrementMemoryUsed(packet);
        }
        Object object = this.inLock;
        synchronized (object) {
            this.inLock.notify();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryManageable remove(Object id) {
        MemoryManageable result = null;
        block5: for (int i = 0; i < 10; ++i) {
            QueueListEntry entry = this.prioritizedPackets[i].getFirstEntry();
            try {
                while (entry != null) {
                    MemoryManageable p = (MemoryManageable)entry.getElement();
                    if (p.getMemoryId().equals(id)) {
                        result = p;
                        this.remove(p);
                        continue block5;
                    }
                    entry = this.prioritizedPackets[i].getNextEntry(entry);
                }
                continue;
            }
            catch (JMSException jmsEx) {
                jmsEx.printStackTrace();
            }
        }
        Object object = this.inLock;
        synchronized (object) {
            this.inLock.notify();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i = 0; i < 10; ++i) {
            while (!this.prioritizedPackets[i].isEmpty()) {
                MemoryManageable packet = (MemoryManageable)this.prioritizedPackets[i].removeFirst();
                this.decrementMemoryUsed(packet);
            }
        }
        Object object = this.inLock;
        synchronized (object) {
            this.inLock.notifyAll();
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < 10; ++i) {
            if (this.prioritizedPackets[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public MemoryManageable get(int index) {
        throw new UnsupportedOperationException("Cannot invoke this method on a MemoryBoundedPrioritizedQueue instance");
    }

    public List getContents() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int j = 9; j >= 0; --j) {
            Object[] array = this.prioritizedPackets[j].toArray();
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
        }
        return list;
    }

    private int getPacketPriority(MemoryManageable packet) {
        int priority = 4;
        if (packet.getPriority() >= 0 || packet.getPriority() <= 9) {
            priority = packet.getPriority();
        }
        return priority;
    }
}

