/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.pool.ConnectionKey;
import org.activemq.pool.PooledConnection;
import org.activemq.service.Service;

public class PooledConnectionFactory
implements ConnectionFactory,
Service {
    private ActiveMQConnectionFactory connectionFactory;
    private Map cache = new HashMap();

    public PooledConnectionFactory() {
        this(new ActiveMQConnectionFactory());
    }

    public PooledConnectionFactory(String brokerURL) {
        this(new ActiveMQConnectionFactory(brokerURL));
    }

    public PooledConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        ConnectionKey key = new ConnectionKey(userName, password);
        PooledConnection connection = (PooledConnection)this.cache.get(key);
        if (connection == null) {
            ActiveMQConnection delegate = this.createConnection(key);
            connection = new PooledConnection(delegate);
            this.cache.put(key, connection);
        }
        return connection.newInstance();
    }

    protected ActiveMQConnection createConnection(ConnectionKey key) throws JMSException {
        if (key.getUserName() == null && key.getPassword() == null) {
            return (ActiveMQConnection)this.connectionFactory.createConnection();
        }
        return (ActiveMQConnection)this.connectionFactory.createConnection(key.getUserName(), key.getPassword());
    }

    public void start() throws JMSException {
        this.createConnection();
    }

    public void stop() throws JMSException {
        Iterator iter = this.cache.values().iterator();
        while (iter.hasNext()) {
            PooledConnection connection = (PooledConnection)iter.next();
            connection.getConnection().close();
            connection.close();
        }
    }
}

