/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.activeio;

import java.io.IOException;
import org.activeio.Packet;
import org.activeio.PacketData;
import org.activeio.packet.AppendedPacket;
import org.activeio.packet.EOSPacket;

public abstract class PacketAggregator {
    private static final int HEADER_LENGTH = 5;
    Packet incompleteUpPacket;
    boolean headerLoaded;
    private int upPacketLength;

    public void addRawPacket(Packet packet) throws IOException {
        if (packet == EOSPacket.EOS_PACKET) {
            this.packetAssembled(packet);
            return;
        }
        if (this.incompleteUpPacket != null) {
            packet = AppendedPacket.join((Packet)this.incompleteUpPacket, (Packet)packet);
            this.incompleteUpPacket = null;
        }
        while (true) {
            if (!this.headerLoaded) {
                boolean bl = this.headerLoaded = packet.remaining() >= 5;
                if (this.headerLoaded) {
                    PacketData data = new PacketData(packet.duplicate());
                    data.readByte();
                    this.upPacketLength = data.readInt();
                    if (this.upPacketLength < 0) {
                        throw new IOException("Up packet lenth was invalid: " + this.upPacketLength);
                    }
                    this.upPacketLength += 5;
                }
                if (!this.headerLoaded) break;
            }
            if (packet.remaining() < this.upPacketLength) break;
            int origLimit = packet.limit();
            packet.limit(this.upPacketLength);
            this.packetAssembled(packet.slice());
            packet.position(this.upPacketLength);
            packet.limit(origLimit);
            packet = packet.slice();
            this.headerLoaded = false;
        }
        if (packet.hasRemaining()) {
            this.incompleteUpPacket = packet;
        }
    }

    protected abstract void packetAssembled(Packet var1);
}

