/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.remote;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import javax.jms.JMSException;
import org.activemq.broker.BrokerConnector;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.impl.BrokerConnectorImpl;
import org.activemq.broker.impl.BrokerContainerImpl;
import org.activemq.io.WireFormat;
import org.activemq.transport.NetworkChannel;
import org.activemq.transport.NetworkConnector;
import org.activemq.transport.RemoteNetworkConnector;
import org.activemq.transport.vm.VmTransportChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteTransportChannel
extends VmTransportChannel {
    private static final Log log = LogFactory.getLog((Class)RemoteTransportChannel.class);
    private WireFormat wireFormat;
    private String remoteUserName;
    private String remotePassword;
    private String brokerName;
    private String remoteLocation;
    private BrokerContainer container;
    private NetworkConnector networkConnector;
    private SynchronizedBoolean brokerConnectorStarted = new SynchronizedBoolean(false);

    protected RemoteTransportChannel(WireFormat wireFormat, String remoteLocation) throws JMSException {
        this.wireFormat = wireFormat;
        this.remoteLocation = remoteLocation;
    }

    public boolean isTransportConnected() {
        return true;
    }

    public boolean requiresEmbeddedBroker() {
        return true;
    }

    public void setClientID(String clientID) {
        super.setClientID(clientID);
        if (this.brokerConnectorStarted.commit(false, true)) {
            if (this.brokerName == null) {
                this.brokerName = clientID;
            }
            if (this.container != null) {
                this.container.getBroker().getBrokerInfo().setBrokerName(this.brokerName);
                this.container.getBroker().getBrokerInfo().setClusterName(this.brokerName);
                try {
                    this.container.start();
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to start brokerConnector", (Throwable)e);
                }
            }
        }
    }

    public void stop() {
        super.stop();
        if (this.container != null) {
            try {
                this.container.stop();
            }
            catch (JMSException e) {
                log.warn((Object)"Caught exception stopping Broker", (Throwable)e);
            }
        }
    }

    public BrokerConnector getEmbeddedBrokerConnector() throws JMSException {
        try {
            BrokerConnectorImpl brokerConnector = null;
            if (this.container == null) {
                this.container = new BrokerContainerImpl("NotSet", "NotSet");
                this.networkConnector = this.networkConnector = new RemoteNetworkConnector(this.container);
                NetworkChannel channel = this.networkConnector.addNetworkChannel(this.remoteLocation);
                channel.setRemoteUserName(this.remoteUserName);
                channel.setRemotePassword(this.remotePassword);
                this.container.addNetworkConnector(this.networkConnector);
                brokerConnector = new BrokerConnectorImpl(this.container);
            }
            return brokerConnector;
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorStr = "Failed to get embedded connector";
            log.error((Object)errorStr, (Throwable)e);
            JMSException jmsEx = new JMSException(errorStr);
            jmsEx.setLinkedException(e);
            throw jmsEx;
        }
    }

    public String getRemoteLocation() {
        return this.remoteLocation;
    }

    public void setRemoteLocation(String remoteLocation) {
        this.remoteLocation = remoteLocation;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public void setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }
}

