/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Joints;
import ai.djl.modality.cv.output.Landmark;
import ai.djl.modality.cv.output.Mask;
import ai.djl.modality.cv.output.Point;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.util.RandomUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;

public class BufferedImageFactory
extends ImageFactory {
    @Override
    public Image fromFile(Path path) throws IOException {
        BufferedImage image = ImageIO.read(path.toFile());
        if (image == null) {
            throw new IOException("Failed to read image from: " + path);
        }
        return new BufferedImageWrapper(image);
    }

    @Override
    public Image fromUrl(URL url) throws IOException {
        BufferedImage image = ImageIO.read(url);
        if (image == null) {
            throw new IOException("Failed to read image from: " + url);
        }
        return new BufferedImageWrapper(image);
    }

    @Override
    public Image fromInputStream(InputStream is) throws IOException {
        BufferedImage image = ImageIO.read(is);
        if (image == null) {
            throw new IOException("Failed to read image from input stream");
        }
        return new BufferedImageWrapper(image);
    }

    @Override
    public Image fromImage(Object image) {
        if (!(image instanceof BufferedImage)) {
            throw new IllegalArgumentException("only BufferedImage allowed");
        }
        return new BufferedImageWrapper((BufferedImage)image);
    }

    @Override
    public Image fromNDArray(NDArray array) {
        Shape shape = array.getShape();
        if (shape.dimension() == 4) {
            throw new UnsupportedOperationException("Batch is not supported");
        }
        if (shape.get(0) == 1L || shape.get(2) == 1L) {
            throw new UnsupportedOperationException("Grayscale image is not supported");
        }
        if (array.getDataType() != DataType.UINT8 && array.getDataType() != DataType.INT8) {
            throw new IllegalArgumentException("Datatype should be INT8 or UINT8");
        }
        if (NDImageUtils.isCHW(shape)) {
            int height = (int)shape.get(1);
            int width = (int)shape.get(2);
            int imageArea = width * height;
            BufferedImage image = new BufferedImage(width, height, 1);
            int[] raw = array.toUint8Array();
            IntStream.range(0, imageArea).parallel().forEach(ele -> {
                int x = ele % width;
                int y = ele / width;
                int red = raw[ele] & 0xFF;
                int green = raw[ele + imageArea] & 0xFF;
                int blue = raw[ele + imageArea * 2] & 0xFF;
                int rgb = red << 16 | green << 8 | blue;
                image.setRGB(x, y, rgb);
            });
            return new BufferedImageWrapper(image);
        }
        int height = (int)shape.get(0);
        int width = (int)shape.get(1);
        int imageArea = width * height;
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] raw = array.toUint8Array();
        IntStream.range(0, imageArea).parallel().forEach(ele -> {
            int x = ele % width;
            int y = ele / width;
            int red = raw[ele * 3] & 0xFF;
            int green = raw[ele * 3 + 1] & 0xFF;
            int blue = raw[ele * 3 + 2] & 0xFF;
            int rgb = red << 16 | green << 8 | blue;
            image.setRGB(x, y, rgb);
        });
        return new BufferedImageWrapper(image);
    }

    protected void save(BufferedImage image, OutputStream os, String type) throws IOException {
        ImageIO.write((RenderedImage)image, type, os);
    }

    static {
        if (System.getProperty("apple.awt.UIElement") == null) {
            System.setProperty("apple.awt.UIElement", "true");
        }
    }

    private class BufferedImageWrapper
    implements Image {
        private final BufferedImage image;

        BufferedImageWrapper(BufferedImage image) {
            this.image = image;
        }

        @Override
        public int getWidth() {
            return this.image.getWidth();
        }

        @Override
        public int getHeight() {
            return this.image.getHeight();
        }

        @Override
        public Object getWrappedImage() {
            return this.image;
        }

        @Override
        public Image getSubimage(int x, int y, int w, int h) {
            return new BufferedImageWrapper(this.image.getSubimage(x, y, w, h));
        }

        @Override
        public Image duplicate(Image.Type type) {
            BufferedImage newImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.getType(type));
            Graphics2D g = newImage.createGraphics();
            g.drawImage((java.awt.Image)this.image, 0, 0, null);
            g.dispose();
            return new BufferedImageWrapper(newImage);
        }

        @Override
        public NDArray toNDArray(NDManager manager, Image.Flag flag) {
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            int channel = flag == Image.Flag.GRAYSCALE ? 1 : 3;
            ByteBuffer bb = manager.allocateDirect(channel * height * width);
            if (this.image.getType() == 10) {
                int[] data = new int[width * height];
                this.image.getData().getPixels(0, 0, width, height, data);
                for (int gray : data) {
                    byte b = (byte)gray;
                    bb.put(b);
                    if (flag == Image.Flag.GRAYSCALE) continue;
                    bb.put(b);
                    bb.put(b);
                }
            } else {
                int[] pixels;
                for (int rgb : pixels = this.image.getRGB(0, 0, width, height, null, 0, width)) {
                    int red = rgb >> 16 & 0xFF;
                    int green = rgb >> 8 & 0xFF;
                    int blue = rgb & 0xFF;
                    if (flag == Image.Flag.GRAYSCALE) {
                        int gray = (red + green + blue) / 3;
                        bb.put((byte)gray);
                        continue;
                    }
                    bb.put((byte)red);
                    bb.put((byte)green);
                    bb.put((byte)blue);
                }
            }
            bb.rewind();
            return manager.create(bb, new Shape(height, width, channel), DataType.UINT8);
        }

        @Override
        public void save(OutputStream os, String type) throws IOException {
            BufferedImageFactory.this.save(this.image, os, type);
        }

        @Override
        public void drawBoundingBoxes(DetectedObjects detections) {
            Graphics2D g = (Graphics2D)this.image.getGraphics();
            int stroke = 2;
            g.setStroke(new BasicStroke(stroke));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int imageWidth = this.image.getWidth();
            int imageHeight = this.image.getHeight();
            List list = detections.items();
            for (DetectedObjects.DetectedObject result : list) {
                String className = result.getClassName();
                BoundingBox box = result.getBoundingBox();
                g.setPaint(this.randomColor().darker());
                Rectangle rectangle = box.getBounds();
                int x = (int)(rectangle.getX() * (double)imageWidth);
                int y = (int)(rectangle.getY() * (double)imageHeight);
                g.drawRect(x, y, (int)(rectangle.getWidth() * (double)imageWidth), (int)(rectangle.getHeight() * (double)imageHeight));
                this.drawText(g, className, x, y, stroke, 4);
                if (box instanceof Mask) {
                    Mask mask = (Mask)box;
                    this.drawMask(this.image, mask);
                    continue;
                }
                if (!(box instanceof Landmark)) continue;
                this.drawLandmarks(this.image, box);
            }
            g.dispose();
        }

        @Override
        public void drawJoints(Joints joints) {
            Graphics2D g = (Graphics2D)this.image.getGraphics();
            int stroke = 2;
            g.setStroke(new BasicStroke(stroke));
            int imageWidth = this.image.getWidth();
            int imageHeight = this.image.getHeight();
            for (Joints.Joint joint : joints.getJoints()) {
                g.setPaint(this.randomColor().darker());
                int x = (int)(joint.getX() * (double)imageWidth);
                int y = (int)(joint.getY() * (double)imageHeight);
                g.fillOval(x, y, 10, 10);
            }
            g.dispose();
        }

        private int getType(Image.Type type) {
            if (type == Image.Type.TYPE_INT_ARGB) {
                return 2;
            }
            throw new IllegalArgumentException("the type is not supported!");
        }

        private Color randomColor() {
            return new Color(RandomUtils.nextInt(255));
        }

        private void drawText(Graphics2D g, String text, int x, int y, int stroke, int padding) {
            FontMetrics metrics = g.getFontMetrics();
            int width = metrics.stringWidth(text) + padding * 2 - stroke / 2;
            int height = metrics.getHeight() + metrics.getDescent();
            int ascent = metrics.getAscent();
            java.awt.Rectangle background = new java.awt.Rectangle(x += stroke / 2, y += stroke / 2, width, height);
            g.fill(background);
            g.setPaint(Color.WHITE);
            g.drawString(text, x + padding, y + ascent);
        }

        private void drawMask(BufferedImage image, Mask mask) {
            float r = RandomUtils.nextFloat();
            float g = RandomUtils.nextFloat();
            float b = RandomUtils.nextFloat();
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            int x = (int)(mask.getX() * (double)imageWidth);
            int y = (int)(mask.getY() * (double)imageHeight);
            float[][] probDist = mask.getProbDist();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            BufferedImage maskImage = new BufferedImage(probDist.length, probDist[0].length, 2);
            for (int xCor = 0; xCor < probDist.length; ++xCor) {
                for (int yCor = 0; yCor < probDist[xCor].length; ++yCor) {
                    float opacity = probDist[xCor][yCor];
                    if ((double)opacity < 0.1) {
                        opacity = 0.0f;
                    }
                    if ((double)opacity > 0.8) {
                        opacity = 0.8f;
                    }
                    maskImage.setRGB(xCor, yCor, new Color(r, g, b, opacity).darker().getRGB());
                }
            }
            Graphics2D gR = (Graphics2D)image.getGraphics();
            gR.drawImage((java.awt.Image)maskImage, x, y, null);
            gR.dispose();
        }

        private void drawLandmarks(BufferedImage image, BoundingBox box) {
            Graphics2D g = (Graphics2D)image.getGraphics();
            g.setColor(new Color(246, 96, 0));
            BasicStroke bStroke = new BasicStroke(4.0f, 0, 0);
            g.setStroke(bStroke);
            for (Point point : box.getPath()) {
                g.drawRect((int)point.getX(), (int)point.getY(), 2, 2);
            }
            g.dispose();
        }
    }
}

