/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.AbstractRepository;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.repository.VersionRange;
import ai.djl.util.JsonUtils;
import ai.djl.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class RemoteRepository
extends AbstractRepository {
    private static final long ONE_DAY = Duration.ofDays(1L).toMillis();
    private String name;
    private URI uri;

    protected RemoteRepository(String name, URI uri) {
        this.name = name;
        this.uri = uri;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getBaseUri() {
        return this.uri;
    }

    /*
     * Loose catch block
     */
    @Override
    public Metadata locate(MRL mrl) throws IOException {
        Path cacheFile;
        URI mrlUri = mrl.toURI();
        URI file = this.uri.resolve(mrlUri.getPath() + "/metadata.json");
        Path cacheDir = this.getCacheDirectory().resolve(mrlUri.getPath());
        if (!Files.exists(cacheDir, new LinkOption[0])) {
            Files.createDirectories(cacheDir, new FileAttribute[0]);
        }
        if (Files.exists(cacheFile = cacheDir.resolve("metadata.json"), new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(cacheFile);){
                Metadata metadata = (Metadata)JsonUtils.GSON_PRETTY.fromJson((Reader)reader, Metadata.class);
                metadata.init();
                Date lastUpdated = metadata.getLastUpdated();
                if (Boolean.getBoolean("offline") || System.currentTimeMillis() - lastUpdated.getTime() < ONE_DAY) {
                    metadata.setRepositoryUri(mrlUri);
                    Metadata metadata2 = metadata;
                    return metadata2;
                }
            }
        }
        Path tmp = Files.createTempFile(cacheDir, "metadata", ".tmp", new FileAttribute[0]);
        try {
            try (InputStream is = file.toURL().openStream();){
                String json = Utils.toString(is);
                Metadata metadata = (Metadata)JsonUtils.GSON_PRETTY.fromJson(json, Metadata.class);
                metadata.init();
                metadata.setLastUpdated(new Date());
                try (BufferedWriter writer = Files.newBufferedWriter(tmp, new OpenOption[0]);){
                    writer.write(JsonUtils.GSON_PRETTY.toJson((Object)metadata));
                }
                Utils.moveQuietly(tmp, cacheFile);
                metadata.setRepositoryUri(mrlUri);
                Metadata metadata3 = metadata;
                return metadata3;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Utils.deleteQuietly(tmp);
        }
    }

    @Override
    public Artifact resolve(MRL mrl, String version, Map<String, String> filter) throws IOException {
        VersionRange range;
        Metadata metadata = this.locate(mrl);
        List<Artifact> artifacts = metadata.search(range = VersionRange.parse(version), filter);
        if (artifacts.isEmpty()) {
            return null;
        }
        return artifacts.get(0);
    }
}

