/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.Application;
import ai.djl.Model;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.translator.ImageClassificationTranslator;
import ai.djl.modality.cv.translator.ImageServingTranslator;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.NoopServingTranslatorFactory;
import ai.djl.translate.ServingTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Pair;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServingTranslatorFactory
implements TranslatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ServingTranslatorFactory.class);

    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return Collections.singleton(new Pair<Class<Input>, Class<Output>>(Input.class, Output.class));
    }

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) throws TranslateException {
        TranslatorFactory factory;
        if (!this.isSupported(input, output)) {
            throw new IllegalArgumentException("Unsupported input/output types.");
        }
        Path modelDir = model.getModelPath();
        String factoryClass = ArgumentsUtil.stringValue(arguments, "translatorFactory");
        if (factoryClass != null && !factoryClass.isEmpty() && (factory = this.loadTranslatorFactory(factoryClass)) != null && factory.isSupported(input, output)) {
            logger.info("Using TranslatorFactory: {}", (Object)factory.getClass().getName());
            return factory.newInstance(input, output, model, arguments);
        }
        String className = (String)arguments.get("translator");
        Path libPath = modelDir.resolve("libs");
        if (!Files.isDirectory(libPath, new LinkOption[0]) && !Files.isDirectory(libPath = modelDir.resolve("lib"), new LinkOption[0]) && className == null) {
            return this.loadDefaultTranslator(arguments);
        }
        ServingTranslator translator = this.findTranslator(libPath, className);
        if (translator != null) {
            translator.setArguments(arguments);
            logger.info("Using translator: {}", (Object)translator.getClass().getName());
            return translator;
        }
        return this.loadDefaultTranslator(arguments);
    }

    private ServingTranslator findTranslator(Path path, String className) {
        try {
            Path classesDir = path.resolve("classes");
            this.compileJavaClass(classesDir);
            ArrayList jarFiles = new ArrayList();
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (Stream<Path> stream = Files.list(path);){
                    stream.forEach(p -> {
                        if (p.toString().endsWith(".jar")) {
                            jarFiles.add(p);
                        }
                    });
                }
            }
            ArrayList<URL> urls = new ArrayList<URL>(jarFiles.size() + 1);
            urls.add(classesDir.toUri().toURL());
            for (Path p2 : jarFiles) {
                urls.add(p2.toUri().toURL());
            }
            ClassLoader parentCl = ClassLoaderUtils.getContextClassLoader();
            URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]), parentCl);
            if (className != null && !className.isEmpty()) {
                logger.info("Trying to loading specified Translator: {}", (Object)className);
                return this.initTranslator(cl, className);
            }
            ServingTranslator translator = this.scanDirectory(cl, classesDir);
            if (translator != null) {
                return translator;
            }
            for (Path p3 : jarFiles) {
                translator = this.scanJarFile(cl, p3);
                if (translator == null) continue;
                return translator;
            }
        }
        catch (IOException e) {
            logger.debug("Failed to find Translator", (Throwable)e);
        }
        return null;
    }

    private ServingTranslator scanDirectory(ClassLoader cl, Path dir) throws IOException {
        Collection files;
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            logger.debug("Directory not exists: {}", (Object)dir);
            return null;
        }
        try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
            files = stream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".class")).collect(Collectors.toList());
        }
        for (Path file : files) {
            Path p2 = dir.relativize(file);
            String className = p2.toString();
            className = className.substring(0, className.lastIndexOf(46));
            ServingTranslator translator = this.initTranslator(cl, className = className.replace(File.separatorChar, '.'));
            if (translator == null) continue;
            logger.info("Found translator in model directory: {}", (Object)className);
            return translator;
        }
        return null;
    }

    private ServingTranslator scanJarFile(ClassLoader cl, Path path) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String fileName = entry.getName();
                if (!fileName.endsWith(".class")) continue;
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
                ServingTranslator translator = this.initTranslator(cl, fileName = fileName.replace('/', '.'));
                if (translator == null) continue;
                logger.info("Found translator {} in jar {}", (Object)fileName, (Object)path);
                ServingTranslator servingTranslator = translator;
                return servingTranslator;
            }
        }
        return null;
    }

    private TranslatorFactory loadTranslatorFactory(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Class<TranslatorFactory> subclass = clazz.asSubclass(TranslatorFactory.class);
            Constructor<TranslatorFactory> constructor = subclass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            logger.trace("Not able to load TranslatorFactory: " + className, e);
            return null;
        }
    }

    private ServingTranslator initTranslator(ClassLoader cl, String className) {
        try {
            Class<?> clazz = Class.forName(className, true, cl);
            Class<ServingTranslator> subclass = clazz.asSubclass(ServingTranslator.class);
            Constructor<ServingTranslator> constructor = subclass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            logger.trace("Not able to load Translator: " + className, e);
            return null;
        }
    }

    private Translator<Input, Output> loadDefaultTranslator(Map<String, ?> arguments) {
        Application application;
        String appName = ArgumentsUtil.stringValue(arguments, "application");
        if (appName != null && (application = Application.of(appName)) == Application.CV.IMAGE_CLASSIFICATION) {
            return this.getImageClassificationTranslator(arguments);
        }
        NoopServingTranslatorFactory factory = new NoopServingTranslatorFactory();
        return factory.newInstance(Input.class, Output.class, null, arguments);
    }

    private Translator<Input, Output> getImageClassificationTranslator(Map<String, ?> arguments) {
        return new ImageServingTranslator(ImageClassificationTranslator.builder(arguments).build());
    }

    private void compileJavaClass(Path dir) {
        try {
            String[] files;
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                logger.debug("Directory not exists: {}", (Object)dir);
                return;
            }
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                files = (String[])stream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".java")).map(p -> p.toAbsolutePath().toString()).toArray(String[]::new);
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (files.length > 0) {
                compiler.run(null, null, null, files);
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to compile bundled java file", e);
        }
    }
}

