/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NeuronUtils {
    private static final Logger logger = LoggerFactory.getLogger(NeuronUtils.class);

    private NeuronUtils() {
    }

    public static boolean hasNeuron() {
        return NeuronUtils.getNeuronCores() > 0;
    }

    public static int getNeuronCores() {
        List<Path> nd = NeuronUtils.getNeuronDevices("/dev/");
        if (nd.isEmpty()) {
            return 0;
        }
        String dev = nd.get(0).toFile().getName();
        int cores = NeuronUtils.getNeuronCoresPerDevice("/sys/devices/virtual/neuron_device/" + dev);
        return nd.size() * cores;
    }

    static List<Path> getNeuronDevices(String location) {
        List<Path> list;
        block9: {
            Path path = Paths.get(location, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> dev = Files.list(path);
            try {
                list = dev.filter(p -> NeuronUtils.matches(p, "neuron")).collect(Collectors.toList());
                if (dev == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dev != null) {
                        try {
                            dev.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn("Failed to list neuron cores", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            dev.close();
        }
        return list;
    }

    static int getNeuronCoresPerDevice(String location) {
        int n;
        block9: {
            Path path = Paths.get(location, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return 0;
            }
            int count = 0;
            Stream<Path> dev = Files.list(path);
            try {
                n = Math.toIntExact(dev.filter(p -> NeuronUtils.matches(p, "neuron_core")).count());
                if (dev == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dev != null) {
                        try {
                            dev.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn("Failed to list neuron cores", (Throwable)e);
                    return count;
                }
            }
            dev.close();
        }
        return n;
    }

    private static boolean matches(Path p, String pattern) {
        return p.toFile().getName().startsWith(pattern);
    }
}

