/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.translator;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;
import ai.djl.util.PairList;
import ai.djl.util.StringPair;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;

public class CrossEncoderServingTranslator
implements NoBatchifyTranslator<Input, Output> {
    private static final Type LIST_TYPE = new TypeToken<List<String>>(){}.getType();
    private Translator<StringPair, float[]> translator;

    public CrossEncoderServingTranslator(Translator<StringPair, float[]> translator) {
        this.translator = translator;
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        StringPair pair;
        block8: {
            PairList<String, BytesSupplier> content = input.getContent();
            if (content.isEmpty()) {
                throw new TranslateException("Input data is empty.");
            }
            String contentType = input.getProperty("Content-Type", null);
            if ("application/json".equals(contentType)) {
                String json = input.getData().getAsString();
                try {
                    JsonElement element = (JsonElement)JsonUtils.GSON.fromJson(json, JsonElement.class);
                    if (element.isJsonArray()) {
                        ctx.setAttachment("batch", Boolean.TRUE);
                        List inputs = (List)JsonUtils.GSON.fromJson(json, LIST_TYPE);
                        return this.translator.batchProcessInput(ctx, inputs);
                    }
                    pair = (StringPair)JsonUtils.GSON.fromJson(json, StringPair.class);
                    if (pair.getKey() == null || pair.getValue() == null) {
                        throw new TranslateException("Missing key or value in json.");
                    }
                    break block8;
                }
                catch (JsonParseException e) {
                    throw new TranslateException("Input is not a valid json.", e);
                }
            }
            String key = input.getAsString("key");
            String value = input.getAsString("value");
            if (key == null || value == null) {
                throw new TranslateException("Missing key or value in input.");
            }
            pair = new StringPair(key, value);
        }
        NDList ret = this.translator.processInput(ctx, pair);
        Batchifier batchifier = this.translator.getBatchifier();
        if (batchifier != null) {
            NDList[] batch = new NDList[]{ret};
            return batchifier.batchify(batch);
        }
        return ret;
    }

    @Override
    public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
        Output output = new Output();
        output.addProperty("Content-Type", "application/json");
        if (ctx.getAttachment("batch") != null) {
            output.add(BytesSupplier.wrapAsJson(this.translator.batchProcessOutput(ctx, list)));
        } else {
            Batchifier batchifier = this.translator.getBatchifier();
            if (batchifier != null) {
                list = batchifier.unbatchify(list)[0];
            }
            output.add(BytesSupplier.wrapAsJson(this.translator.processOutput(ctx, list)));
        }
        return output;
    }
}

