/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.tabular.utils;

import ai.djl.basicdataset.tabular.utils.DynamicBuffer;
import ai.djl.basicdataset.tabular.utils.Featurizer;
import ai.djl.basicdataset.tabular.utils.PreparedFeaturizer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public final class Featurizers {
    private static final Featurizer NUMERIC_FEATURIZER = new NumericFeaturizer();

    private Featurizers() {
    }

    public static Featurizer getNumericFeaturizer() {
        return Featurizers.getNumericFeaturizer(false);
    }

    public static Featurizer getNumericFeaturizer(boolean normalize) {
        if (normalize) {
            return new NormalizedNumericFeaturizer();
        }
        return NUMERIC_FEATURIZER;
    }

    public static Featurizer getStringFeaturizer() {
        return Featurizers.getStringFeaturizer(true);
    }

    public static Featurizer getStringFeaturizer(boolean onehotEncode) {
        if (onehotEncode) {
            return new PreparedOneHotStringFeaturizer();
        }
        return new StringFeaturizer();
    }

    public static Featurizer getStringFeaturizer(Map<String, Integer> map, boolean onehotEncode) {
        if (onehotEncode) {
            return new OneHotStringFeaturizer(map);
        }
        return new StringFeaturizer(map);
    }

    public static Featurizer getEpochDayFeaturizer(String datePattern) {
        return new EpochDayFeaturizer(datePattern);
    }

    private static final class EpochDayFeaturizer
    implements Featurizer {
        String datePattern;

        EpochDayFeaturizer(String datePattern) {
            this.datePattern = datePattern;
        }

        @Override
        public void featurize(DynamicBuffer buf, String input) {
            LocalDate ld = LocalDate.parse(input, DateTimeFormatter.ofPattern(this.datePattern));
            long day = ld.toEpochDay();
            buf.put(day);
        }
    }

    private static final class StringFeaturizer
    implements Featurizer {
        private Map<String, Integer> map;
        private boolean autoMap;

        StringFeaturizer() {
            this.map = new HashMap<String, Integer>();
            this.autoMap = true;
        }

        StringFeaturizer(Map<String, Integer> map) {
            this.map = map;
        }

        @Override
        public void featurize(DynamicBuffer buf, String input) {
            Integer index = this.map.get(input);
            if (index != null) {
                buf.put(index.intValue());
                return;
            }
            if (!this.autoMap) {
                throw new IllegalArgumentException("Value: " + input + " not found in the map.");
            }
            int value = this.map.size();
            this.map.put(input, value);
            buf.put(value);
        }
    }

    private static final class PreparedOneHotStringFeaturizer
    extends OneHotStringFeaturizer
    implements PreparedFeaturizer {
        public PreparedOneHotStringFeaturizer() {
            super(null);
        }

        @Override
        public void prepare(List<String> inputs) {
            this.map = new ConcurrentHashMap();
            TreeSet<String> uniqueInputs = new TreeSet<String>(inputs);
            for (String input : uniqueInputs) {
                if (this.map.containsKey(input)) continue;
                this.map.put(input, this.map.size());
            }
        }
    }

    private static class OneHotStringFeaturizer
    implements Featurizer {
        protected Map<String, Integer> map;

        public OneHotStringFeaturizer(Map<String, Integer> map) {
            this.map = map;
        }

        @Override
        public void featurize(DynamicBuffer buf, String input) {
            for (int i = 0; i < this.map.size(); ++i) {
                buf.put(i == this.map.get(input) ? 1.0f : 0.0f);
            }
        }
    }

    private static final class NormalizedNumericFeaturizer
    implements PreparedFeaturizer {
        private float mean;
        private float std;

        private NormalizedNumericFeaturizer() {
        }

        @Override
        public void featurize(DynamicBuffer buf, String input) {
            float value = (Float.parseFloat(input) - this.mean) / this.std;
            buf.put(value);
        }

        @Override
        public void prepare(List<String> inputs) {
            this.calculateMean(inputs);
            this.calculateStd(inputs);
        }

        private void calculateMean(List<String> inputs) {
            double sum = 0.0;
            for (String input : inputs) {
                sum += (double)Float.parseFloat(input);
            }
            this.mean = (float)(sum / (double)inputs.size());
        }

        private void calculateStd(List<String> inputs) {
            double sum = 0.0;
            for (String input : inputs) {
                sum += Math.pow(Float.parseFloat(input) - this.mean, 2.0);
            }
            this.std = (float)Math.sqrt(sum / (double)inputs.size());
        }
    }

    private static final class NumericFeaturizer
    implements Featurizer {
        private NumericFeaturizer() {
        }

        @Override
        public void featurize(DynamicBuffer buf, String input) {
            buf.put(Float.parseFloat(input));
        }
    }
}

