/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.nlp;

import ai.djl.Application;
import ai.djl.basicdataset.nlp.TextDataset;
import ai.djl.modality.nlp.embedding.EmbeddingException;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.training.dataset.Record;
import ai.djl.util.Progress;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class GoEmotions
extends TextDataset {
    private static final String ARTIFACT_ID = "goemotions";
    private static final String VERSION = "1.0";
    List<int[]> targetData = new ArrayList<int[]>();

    GoEmotions(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
    }

    public void prepare(Progress progress) throws IOException, EmbeddingException {
        List csvRecords;
        Path csvFile;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact, progress);
        Path root = this.mrl.getRepository().getResourceDirectory(artifact);
        switch (this.usage) {
            case TRAIN: {
                csvFile = root.resolve("train.tsv");
                break;
            }
            case TEST: {
                csvFile = root.resolve("test.tsv");
                break;
            }
            case VALIDATION: {
                csvFile = root.resolve("dev.tsv");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Data not available.");
            }
        }
        CSVFormat csvFormat = CSVFormat.TDF.builder().setQuote(null).setHeader(HeaderEnum.class).get();
        URL csvUrl = csvFile.toUri().toURL();
        ArrayList<String> sourceTextData = new ArrayList<String>();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(csvUrl.openStream()), StandardCharsets.UTF_8);){
            CSVParser csvParser = CSVParser.parse((Reader)reader, (CSVFormat)csvFormat);
            csvRecords = csvParser.getRecords();
        }
        for (CSVRecord csvRecord : csvRecords) {
            sourceTextData.add(csvRecord.get(0));
            String[] labels = csvRecord.get(1).split(",");
            int[] labelInt = new int[labels.length];
            for (int i = 0; i < labels.length; ++i) {
                labelInt[i] = Integer.parseInt(labels[i]);
            }
            this.targetData.add(labelInt);
        }
        this.preprocess(sourceTextData, true);
        this.prepared = true;
    }

    public Record get(NDManager manager, long index) throws IOException {
        NDList data = new NDList();
        NDList labels = new NDList();
        data.add((Object)this.sourceTextData.getEmbedding(manager, index));
        labels.add((Object)manager.create(this.targetData.get((int)index)));
        return new Record(data, labels);
    }

    protected long availableSize() {
        return this.sourceTextData.getSize();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends TextDataset.Builder<Builder> {
        public Builder() {
            this.artifactId = GoEmotions.ARTIFACT_ID;
        }

        public Builder self() {
            return this;
        }

        public GoEmotions build() {
            return new GoEmotions(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.NLP.ANY, this.groupId, this.artifactId, GoEmotions.VERSION);
        }
    }

    static enum HeaderEnum {
        text,
        emotion_id,
        comment_id;

    }
}

