/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicmodelzoo.cv.classification;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.basicmodelzoo.basic.Mlp;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.transform.CenterCrop;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.translator.ImageClassificationTranslator;
import ai.djl.modality.cv.translator.wrapper.FileTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.InputStreamTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.UrlTranslatorFactory;
import ai.djl.nn.Block;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class MlpModelLoader
extends BaseModelLoader<Image, Classifications> {
    private static final Application APPLICATION = Application.CV.IMAGE_CLASSIFICATION;
    private static final String GROUP_ID = "ai.djl.zoo";
    private static final String ARTIFACT_ID = "mlp";
    private static final String VERSION = "0.0.2";

    public MlpModelLoader(Repository repository) {
        super(repository, MRL.model((Application)APPLICATION, (String)GROUP_ID, (String)ARTIFACT_ID), VERSION, null);
        FactoryImpl factory = new FactoryImpl();
        this.factories.put(new Pair(Image.class, Classifications.class), factory);
        this.factories.put(new Pair(Path.class, Classifications.class), new FileTranslatorFactory((TranslatorFactory)factory));
        this.factories.put(new Pair(URL.class, Classifications.class), new UrlTranslatorFactory((TranslatorFactory)factory));
        this.factories.put(new Pair(InputStream.class, Classifications.class), new InputStreamTranslatorFactory((TranslatorFactory)factory));
    }

    public Application getApplication() {
        return APPLICATION;
    }

    public ZooModel<Image, Classifications> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria criteria = Criteria.builder().setTypes(Image.class, Classifications.class).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    protected Model createModel(String name, Device device, Artifact artifact, Map<String, Object> arguments, String engine) {
        int width = ((Double)arguments.getOrDefault("width", 28.0)).intValue();
        int height = ((Double)arguments.getOrDefault("height", 28.0)).intValue();
        int input = width * height;
        int output = ((Double)arguments.get("output")).intValue();
        int[] hidden = ((List)arguments.get("hidden")).stream().mapToInt(Double::intValue).toArray();
        Model model = Model.newInstance((String)name, (Device)device, (String)engine);
        model.setBlock((Block)new Mlp(input, output, hidden));
        return model;
    }

    private static final class FactoryImpl
    implements TranslatorFactory<Image, Classifications> {
        private FactoryImpl() {
        }

        public Translator<Image, Classifications> newInstance(Map<String, Object> arguments) {
            int width = ((Double)arguments.getOrDefault("width", 28.0)).intValue();
            int height = ((Double)arguments.getOrDefault("height", 28.0)).intValue();
            String flag = (String)arguments.getOrDefault("flag", Image.Flag.COLOR.name());
            return ((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)ImageClassificationTranslator.builder().optFlag(Image.Flag.valueOf((String)flag))).addTransform((Transform)new CenterCrop())).addTransform((Transform)new Resize(width, height))).addTransform((Transform)new ToTensor())).build();
        }
    }
}

