package ai.djl.mxnet.jna;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class OtherOptionSpace extends Structure {

    public OtherOptionEntity.ByReference entities;
    public int entities_size;

    public OtherOptionSpace() {
    }

    public OtherOptionSpace(Pointer peer) {
        super(peer);
    }

    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("entities", "entities_size");
    }

    public void setEntities(OtherOptionEntity.ByReference entities) {
        this.entities = entities;
    }

    public OtherOptionEntity.ByReference getEntities() {
        return entities;
    }

    public void setEntitiesSize(int entities_size) {
        this.entities_size = entities_size;
    }

    public int getEntitiesSize() {
        return entities_size;
    }

    public static final class ByReference extends OtherOptionSpace implements Structure.ByReference {}

    public static final class ByValue extends OtherOptionSpace implements Structure.ByValue {}
}
