/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import ai.djl.mxnet.jna.ObjectPool;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;

final class PointerArray
extends Memory {
    private static final ObjectPool<PointerArray> POOL = new ObjectPool(null, null);
    private int length;

    private PointerArray(Pointer ... arg) {
        super((long)(Native.POINTER_SIZE * (arg.length + 1)));
        this.length = arg.length;
        this.setPointers(arg);
    }

    public static PointerArray of(Pointer ... arg) {
        PointerArray array = POOL.acquire();
        if (array != null && array.length >= arg.length) {
            array.setPointers(arg);
            return array;
        }
        return new PointerArray(arg);
    }

    public void recycle() {
        POOL.recycle(this);
    }

    private void setPointers(Pointer[] pointers) {
        for (int i = 0; i < pointers.length; ++i) {
            this.setPointer(i * Native.POINTER_SIZE, pointers[i]);
        }
        this.setPointer(Native.POINTER_SIZE * this.length, null);
    }

    public boolean equals(Object o) {
        return o == this;
    }
}

