/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.zoo.nlp.qa;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.pytorch.zoo.PtModelZoo;
import ai.djl.pytorch.zoo.nlp.qa.PtBertQATranslator;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import ai.djl.util.Progress;
import java.io.IOException;
import java.util.Map;

public class BertQAModelLoader
extends BaseModelLoader<QAInput, String> {
    private static final Application APPLICATION = Application.NLP.QUESTION_ANSWER;
    private static final String GROUP_ID = "ai.djl.pytorch";
    private static final String ARTIFACT_ID = "bertqa";
    private static final String VERSION = "0.0.1";

    public BertQAModelLoader(Repository repository) {
        super(repository, MRL.model((Application)APPLICATION, (String)GROUP_ID, (String)ARTIFACT_ID), VERSION, (ModelZoo)new PtModelZoo());
        this.factories.put(new Pair(QAInput.class, String.class), new FactoryImpl());
    }

    public ZooModel<QAInput, String> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria criteria = Criteria.builder().setTypes(QAInput.class, String.class).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    public Application getApplication() {
        return APPLICATION;
    }

    private static final class FactoryImpl
    implements TranslatorFactory<QAInput, String> {
        private FactoryImpl() {
        }

        public Translator<QAInput, String> newInstance(Map<String, Object> arguments) {
            return PtBertQATranslator.builder().build();
        }
    }
}

