/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class ResourceGather<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "ResourceGather";
    private Output<U> output;

    public static <U extends TType> ResourceGather<U> create(Scope scope, Operand<?> resource, Operand<? extends TNumber> indices, Class<U> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(resource.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.batchDims != null) {
                    opBuilder.setAttr("batch_dims", opts.batchDims);
                }
                if (opts.validateIndices == null) continue;
                opBuilder.setAttr("validate_indices", opts.validateIndices);
            }
        }
        return new ResourceGather<U>(opBuilder.build());
    }

    public static Options batchDims(Long batchDims) {
        return new Options().batchDims(batchDims);
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    private ResourceGather(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long batchDims;
        private Boolean validateIndices;

        public Options batchDims(Long batchDims) {
            this.batchDims = batchDims;
            return this;
        }

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }

        private Options() {
        }
    }
}

