/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.debugging;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class DebugNumericsSummary<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "DebugNumericSummaryV2";
    private Output<U> output;

    public static <U extends TNumber> DebugNumericsSummary<U> create(Scope scope, Operand<? extends TType> input, Class<U> outputDtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("DebugNumericsSummary"));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("output_dtype", Operands.toDataType(outputDtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.tensorDebugMode != null) {
                    opBuilder.setAttr("tensor_debug_mode", opts.tensorDebugMode);
                }
                if (opts.tensorId == null) continue;
                opBuilder.setAttr("tensor_id", opts.tensorId);
            }
        }
        return new DebugNumericsSummary<U>(opBuilder.build());
    }

    public static DebugNumericsSummary<TFloat32> create(Scope scope, Operand<? extends TType> input, Options ... options) {
        return DebugNumericsSummary.create(scope, input, TFloat32.class, options);
    }

    public static Options tensorDebugMode(Long tensorDebugMode) {
        return new Options().tensorDebugMode(tensorDebugMode);
    }

    public static Options tensorId(Long tensorId) {
        return new Options().tensorId(tensorId);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    private DebugNumericsSummary(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long tensorDebugMode;
        private Long tensorId;

        public Options tensorDebugMode(Long tensorDebugMode) {
            this.tensorDebugMode = tensorDebugMode;
            return this;
        }

        public Options tensorId(Long tensorId) {
            this.tensorId = tensorId;
            return this;
        }

        private Options() {
        }
    }
}

