/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;

public final class BoostedTreesMakeQuantileSummaries
extends RawOp
implements Iterable<Operand<TFloat32>> {
    public static final String OP_NAME = "BoostedTreesMakeQuantileSummaries";
    private List<Output<TFloat32>> summaries;

    public static BoostedTreesMakeQuantileSummaries create(Scope scope, Iterable<Operand<TFloat32>> floatValues, Operand<TFloat32> exampleWeights, Operand<TFloat32> epsilon) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInputList(Operands.asOutputs(floatValues));
        opBuilder.addInput(exampleWeights.asOutput());
        opBuilder.addInput(epsilon.asOutput());
        opBuilder = scope.apply(opBuilder);
        return new BoostedTreesMakeQuantileSummaries(opBuilder.build());
    }

    public List<Output<TFloat32>> summaries() {
        return this.summaries;
    }

    @Override
    public Iterator<Operand<TFloat32>> iterator() {
        return this.summaries.iterator();
    }

    private BoostedTreesMakeQuantileSummaries(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int summariesLength = operation.outputListLength("summaries");
        this.summaries = Arrays.asList(operation.outputList(outputIdx, summariesLength));
        outputIdx += summariesLength;
    }
}

