/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

public final class ImageProjectiveTransformV3<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ImageProjectiveTransformV3";
    private Output<T> transformedImages;

    public static <T extends TNumber> ImageProjectiveTransformV3<T> create(Scope scope, Operand<T> images, Operand<TFloat32> transforms, Operand<TInt32> outputShape, Operand<TFloat32> fillValue, String interpolation, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(transforms.asOutput());
        opBuilder.addInput(outputShape.asOutput());
        opBuilder.addInput(fillValue.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("interpolation", interpolation);
        if (options != null) {
            for (Options opts : options) {
                if (opts.fillMode == null) continue;
                opBuilder.setAttr("fill_mode", opts.fillMode);
            }
        }
        return new ImageProjectiveTransformV3<T>(opBuilder.build());
    }

    public static Options fillMode(String fillMode) {
        return new Options().fillMode(fillMode);
    }

    public Output<T> transformedImages() {
        return this.transformedImages;
    }

    @Override
    public Output<T> asOutput() {
        return this.transformedImages;
    }

    private ImageProjectiveTransformV3(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.transformedImages = operation.output(outputIdx++);
    }

    public static class Options {
        private String fillMode;

        public Options fillMode(String fillMode) {
            this.fillMode = fillMode;
            return this;
        }

        private Options() {
        }
    }
}

