/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

public final class QuantizedBatchNormWithGlobalNormalization<U extends TType>
extends RawOp {
    public static final String OP_NAME = "QuantizedBatchNormWithGlobalNormalization";
    private Output<U> result;
    private Output<TFloat32> resultMin;
    private Output<TFloat32> resultMax;

    public static <U extends TType, T extends TType> QuantizedBatchNormWithGlobalNormalization<U> create(Scope scope, Operand<T> t, Operand<TFloat32> tMin, Operand<TFloat32> tMax, Operand<T> m, Operand<TFloat32> mMin, Operand<TFloat32> mMax, Operand<T> v, Operand<TFloat32> vMin, Operand<TFloat32> vMax, Operand<T> beta, Operand<TFloat32> betaMin, Operand<TFloat32> betaMax, Operand<T> gamma, Operand<TFloat32> gammaMin, Operand<TFloat32> gammaMax, Class<U> outType, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(t.asOutput());
        opBuilder.addInput(tMin.asOutput());
        opBuilder.addInput(tMax.asOutput());
        opBuilder.addInput(m.asOutput());
        opBuilder.addInput(mMin.asOutput());
        opBuilder.addInput(mMax.asOutput());
        opBuilder.addInput(v.asOutput());
        opBuilder.addInput(vMin.asOutput());
        opBuilder.addInput(vMax.asOutput());
        opBuilder.addInput(beta.asOutput());
        opBuilder.addInput(betaMin.asOutput());
        opBuilder.addInput(betaMax.asOutput());
        opBuilder.addInput(gamma.asOutput());
        opBuilder.addInput(gammaMin.asOutput());
        opBuilder.addInput(gammaMax.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        opBuilder.setAttr("variance_epsilon", varianceEpsilon.floatValue());
        opBuilder.setAttr("scale_after_normalization", scaleAfterNormalization);
        return new QuantizedBatchNormWithGlobalNormalization<U>(opBuilder.build());
    }

    public Output<U> result() {
        return this.result;
    }

    public Output<TFloat32> resultMin() {
        return this.resultMin;
    }

    public Output<TFloat32> resultMax() {
        return this.resultMax;
    }

    private QuantizedBatchNormWithGlobalNormalization(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.result = operation.output(outputIdx++);
        this.resultMin = operation.output(outputIdx++);
        this.resultMax = operation.output(outputIdx++);
    }
}

