/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.random;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;

public final class UniformCandidateSampler
extends RawOp {
    public static final String OP_NAME = "UniformCandidateSampler";
    private Output<TInt64> sampledCandidates;
    private Output<TFloat32> trueExpectedCount;
    private Output<TFloat32> sampledExpectedCount;

    public static UniformCandidateSampler create(Scope scope, Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(trueClasses.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("num_true", numTrue);
        opBuilder.setAttr("num_sampled", numSampled);
        opBuilder.setAttr("unique", unique);
        opBuilder.setAttr("range_max", rangeMax);
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new UniformCandidateSampler(opBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<TInt64> sampledCandidates() {
        return this.sampledCandidates;
    }

    public Output<TFloat32> trueExpectedCount() {
        return this.trueExpectedCount;
    }

    public Output<TFloat32> sampledExpectedCount() {
        return this.sampledExpectedCount;
    }

    private UniformCandidateSampler(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.sampledCandidates = operation.output(outputIdx++);
        this.trueExpectedCount = operation.output(outputIdx++);
        this.sampledExpectedCount = operation.output(outputIdx++);
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

