/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class PartitionedInput<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TPUPartitionedInput";
    private Output<T> output;

    public static <T extends TType> PartitionedInput<T> create(Scope scope, Iterable<Operand<T>> inputs, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("PartitionedInput"));
        opBuilder.addInputList(Operands.asOutputs(inputs));
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.partitionDim == null) continue;
                opBuilder.setAttr("partition_dim", opts.partitionDim);
            }
        }
        return new PartitionedInput<T>(opBuilder.build());
    }

    public static Options partitionDim(Long partitionDim) {
        return new Options().partitionDim(partitionDim);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private PartitionedInput(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long partitionDim;

        public Options partitionDim(Long partitionDim) {
            this.partitionDim = partitionDim;
            return this;
        }

        private Options() {
        }
    }
}

