/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class PartitionedOutput<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "TPUPartitionedOutput";
    private List<Output<T>> output;

    public static <T extends TType> PartitionedOutput<T> create(Scope scope, Operand<T> inputs, Long numSplits, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("PartitionedOutput"));
        opBuilder.addInput(inputs.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("num_splits", numSplits);
        if (options != null) {
            for (Options opts : options) {
                if (opts.partitionDim == null) continue;
                opBuilder.setAttr("partition_dim", opts.partitionDim);
            }
        }
        return new PartitionedOutput<T>(opBuilder.build());
    }

    public static Options partitionDim(Long partitionDim) {
        return new Options().partitionDim(partitionDim);
    }

    public List<Output<T>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    private PartitionedOutput(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static class Options {
        private Long partitionDim;

        public Options partitionDim(Long partitionDim) {
            this.partitionDim = partitionDim;
            return this;
        }

        private Options() {
        }
    }
}

