/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class Svd<T extends TType>
extends RawOp {
    public static final String OP_NAME = "XlaSvd";
    private Output<T> s;
    private Output<T> u;
    private Output<T> v;

    public static <T extends TType> Svd<T> create(Scope scope, Operand<T> a, Long maxIter, Float epsilon, String precisionConfig) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("Svd"));
        opBuilder.addInput(a.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("max_iter", maxIter);
        opBuilder.setAttr("epsilon", epsilon.floatValue());
        opBuilder.setAttr("precision_config", precisionConfig);
        return new Svd<T>(opBuilder.build());
    }

    public Output<T> s() {
        return this.s;
    }

    public Output<T> u() {
        return this.u;
    }

    public Output<T> v() {
        return this.v;
    }

    private Svd(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.s = operation.output(outputIdx++);
        this.u = operation.output(outputIdx++);
        this.v = operation.output(outputIdx++);
    }
}

