/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.tensorflow.RawTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.impl.dense.FloatDenseNdArray;
import org.tensorflow.types.TFloat32;

public final class TFloat32Mapper
extends TensorMapper<TFloat32> {
    @Override
    protected TFloat32 mapDense(RawTensor tensor) {
        FloatDataBuffer buffer = TensorBuffers.toFloats(TFloat32Mapper.nativeHandle(tensor));
        return new DenseTFloat32(tensor, buffer);
    }

    private static final class DenseTFloat32
    extends FloatDenseNdArray
    implements TFloat32 {
        final RawTensor rawTensor;

        public Class<TFloat32> type() {
            return TFloat32.class;
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTFloat32(RawTensor rawTensor, FloatDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

