/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.layout;

import java.nio.charset.Charset;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.layout.DataLayout;

public final class StringLayout
implements DataLayout<DataBuffer<byte[]>, String> {
    private final Charset charset;

    public static StringLayout of(Charset charset) {
        return new StringLayout(charset);
    }

    @Override
    public void writeObject(DataBuffer<byte[]> buffer, String value, long index) {
        buffer.setObject(value.getBytes(this.charset), index);
    }

    @Override
    public String readObject(DataBuffer<byte[]> buffer, long index) {
        return new String(buffer.getObject(index), this.charset);
    }

    private StringLayout(Charset charset) {
        this.charset = charset;
    }
}

