/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.nio;

import java.nio.ByteBuffer;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataStorageVisitor;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.buffer.layout.DataLayouts;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.adapter.DataBufferAdapterFactory;
import org.tensorflow.ndarray.impl.buffer.nio.AbstractNioDataBuffer;
import org.tensorflow.ndarray.impl.buffer.nio.DoubleNioDataBuffer;
import org.tensorflow.ndarray.impl.buffer.nio.FloatNioDataBuffer;
import org.tensorflow.ndarray.impl.buffer.nio.IntNioDataBuffer;
import org.tensorflow.ndarray.impl.buffer.nio.LongNioDataBuffer;
import org.tensorflow.ndarray.impl.buffer.nio.ShortNioDataBuffer;

final class ByteNioDataBuffer
extends AbstractNioDataBuffer<Byte>
implements ByteDataBuffer {
    private ByteBuffer buf;

    @Override
    public byte getByte(long index) {
        return this.buf.get((int)index);
    }

    @Override
    public ByteDataBuffer setByte(byte value, long index) {
        this.buf.put((int)index, value);
        return this;
    }

    @Override
    public ByteDataBuffer read(byte[] dst, int offset, int length) {
        this.buf.duplicate().get(dst, offset, length);
        return this;
    }

    @Override
    public ByteDataBuffer write(byte[] src, int offset, int length) {
        this.buf.duplicate().put(src, offset, length);
        return this;
    }

    @Override
    public ByteDataBuffer copyTo(final DataBuffer<Byte> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<ByteDataBuffer>(){

            @Override
            public ByteDataBuffer visit(ByteBuffer buffer) {
                buffer.duplicate().put((ByteBuffer)ByteNioDataBuffer.this.buf.duplicate().limit((int)size));
                return ByteNioDataBuffer.this;
            }

            @Override
            public ByteDataBuffer fallback() {
                if (dst instanceof ByteDataBuffer) {
                    ByteDataBuffer byteDst = (ByteDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        byteDst.setByte(ByteNioDataBuffer.this.getByte(idx), idx);
                    }
                    return ByteNioDataBuffer.this;
                }
                return (ByteDataBuffer)ByteNioDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public IntDataBuffer asInts() {
        return new IntNioDataBuffer(this.buf.asIntBuffer());
    }

    @Override
    public ShortDataBuffer asShorts() {
        return new ShortNioDataBuffer(this.buf.asShortBuffer());
    }

    @Override
    public LongDataBuffer asLongs() {
        return new LongNioDataBuffer(this.buf.asLongBuffer());
    }

    @Override
    public FloatDataBuffer asFloats() {
        return new FloatNioDataBuffer(this.buf.asFloatBuffer());
    }

    @Override
    public DoubleDataBuffer asDoubles() {
        return new DoubleNioDataBuffer(this.buf.asDoubleBuffer());
    }

    @Override
    public BooleanDataBuffer asBooleans() {
        return DataBufferAdapterFactory.create(this, DataLayouts.BOOL);
    }

    @Override
    public ByteDataBuffer offset(long index) {
        Validator.offsetArgs(this, index);
        return new ByteNioDataBuffer(((ByteBuffer)this.buf.duplicate().position((int)index)).slice());
    }

    @Override
    public ByteDataBuffer narrow(long size) {
        Validator.narrowArgs(this, size);
        return new ByteNioDataBuffer(((ByteBuffer)this.buf.duplicate().limit((int)size)).slice());
    }

    @Override
    public ByteDataBuffer slice(long index, long size) {
        Validator.sliceArgs(this, index, size);
        ByteBuffer sliceBuf = this.buf.duplicate();
        sliceBuf.position((int)index);
        sliceBuf.limit((int)index + (int)size);
        return new ByteNioDataBuffer(sliceBuf.slice());
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        return visitor.visit(this.buf);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteDataBuffer)) {
            return super.equals(obj);
        }
        final ByteDataBuffer other = (ByteDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(ByteBuffer buffer) {
                return ByteNioDataBuffer.this.buf.equals(buffer);
            }

            @Override
            public Boolean fallback() {
                int idx = 0;
                while ((long)idx < ByteNioDataBuffer.this.size()) {
                    if (other.getByte(idx) != ByteNioDataBuffer.this.getByte(idx)) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }
        });
    }

    @Override
    ByteBuffer buf() {
        return this.buf;
    }

    ByteNioDataBuffer(ByteBuffer buf) {
        this.buf = buf;
    }
}

