/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.Shape;
import org.tensorflow.op.core.Shapes;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class ShapeOps {
    private final Scope scope;
    private final Ops ops;

    ShapeOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public Operand<TInt64> append(Shape<TInt64> shape, long lastDimension) {
        return Shapes.append(this.scope, shape, lastDimension);
    }

    public Operand<TInt32> append(Shape<TInt32> shape, int lastDimension) {
        return Shapes.append(this.scope, shape, lastDimension);
    }

    public <T extends TNumber> Operand<T> append(Operand<T> shape, Operand<T> shapeToAppend) {
        return Shapes.append(this.scope, shape, shapeToAppend);
    }

    public <T extends TType> Operand<T> flatten(Operand<T> operand) {
        return Shapes.flatten(this.scope, operand);
    }

    public Operand<TInt32> flatten(Shape<TInt32> shape) {
        return Shapes.flatten(this.scope, shape);
    }

    public <T extends TType, U extends TNumber> Operand<T> flatten(Operand<T> operand, Class<U> type) {
        return Shapes.flatten(this.scope, operand, type);
    }

    public <U extends TNumber> Operand<U> flatten(Shape<U> shape, Class<U> type) {
        return Shapes.flatten(this.scope, shape, type);
    }

    public Operand<TInt32> head(Shape<TInt32> shape) {
        return Shapes.head(this.scope, shape);
    }

    public <U extends TNumber> Operand<U> head(Shape<U> shape, Class<U> type) {
        return Shapes.head(this.scope, shape, type);
    }

    public Operand<TInt32> numDimensions(Shape<TInt32> shape) {
        return Shapes.numDimensions(this.scope, shape);
    }

    public <U extends TNumber> Operand<U> numDimensions(Shape<U> shape, Class<U> type) {
        return Shapes.numDimensions(this.scope, shape, type);
    }

    public Operand<TInt64> prepend(Shape<TInt64> shape, long firstDimension) {
        return Shapes.prepend(this.scope, shape, firstDimension);
    }

    public Operand<TInt32> prepend(Shape<TInt32> shape, int firstDimension) {
        return Shapes.prepend(this.scope, shape, firstDimension);
    }

    public <T extends TNumber> Operand<T> prepend(Operand<T> shape, Operand<T> shapeToPrepend) {
        return Shapes.prepend(this.scope, shape, shapeToPrepend);
    }

    public <T extends TType> Operand<T> reduceDims(Operand<T> operand, Operand<TInt32> axis) {
        return Shapes.reduceDims(this.scope, operand, axis);
    }

    public Operand<TInt32> reduceDims(Shape<TInt32> shape, Operand<TInt32> axis) {
        return Shapes.reduceDims(this.scope, shape, axis);
    }

    public <T extends TType, U extends TNumber> Operand<T> reduceDims(Operand<T> operand, Operand<U> axis, Class<U> type) {
        return Shapes.reduceDims(this.scope, operand, axis, type);
    }

    public <U extends TNumber> Operand<U> reduceDims(Shape<U> shape, Operand<U> axis, Class<U> type) {
        return Shapes.reduceDims(this.scope, shape, axis, type);
    }

    public Operand<TInt32> size(Shape<TInt32> shape) {
        return Shapes.size(this.scope, shape);
    }

    public <T extends TType> Operand<TInt32> size(Operand<T> input, Operand<TInt32> dim) {
        return Shapes.size(this.scope, input, dim);
    }

    public Operand<TInt32> size(Shape<TInt32> shape, Operand<TInt32> dim) {
        return Shapes.size(this.scope, shape, dim);
    }

    public <U extends TNumber> Operand<U> size(Shape<U> shape, Class<U> type) {
        return Shapes.size(this.scope, shape, type);
    }

    public <T extends TType, U extends TNumber> Operand<U> size(Operand<T> input, Operand<U> dim, Class<U> type) {
        return Shapes.size(this.scope, input, dim, type);
    }

    public <U extends TNumber> Operand<U> size(Shape<U> shape, Operand<U> dim, Class<U> type) {
        return Shapes.size(this.scope, shape, dim, type);
    }

    public Operand<TInt32> squeeze(Shape<TInt32> shape) {
        return Shapes.squeeze(this.scope, shape);
    }

    public <U extends TNumber> Operand<U> squeeze(Shape<U> shape, Class<U> type) {
        return Shapes.squeeze(this.scope, shape, type);
    }

    public Operand<TInt32> tail(Shape<TInt32> shape) {
        return Shapes.tail(this.scope, shape);
    }

    public <U extends TNumber> Operand<U> tail(Shape<U> shape, Class<U> type) {
        return Shapes.tail(this.scope, shape, type);
    }

    public Operand<TInt32> take(Shape<TInt32> shape, Operand<TInt32> n) {
        return Shapes.take(this.scope, shape, n);
    }

    public <U extends TNumber> Operand<U> take(Shape<U> shape, Operand<U> n, Class<U> type) {
        return Shapes.take(this.scope, shape, n, type);
    }

    public <U extends TNumber> Operand<TInt32> takeLast(Shape<TInt32> shape, Operand<TInt32> n) {
        return Shapes.takeLast(this.scope, shape, n);
    }

    public <U extends TNumber> Operand<U> takeLast(Shape<U> shape, Operand<U> n, Class<U> type) {
        return Shapes.takeLast(this.scope, shape, n, type);
    }

    public final Ops ops() {
        return this.ops;
    }
}

