/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="ExtractVolumePatches", inputsClass=Inputs.class)
public final class ExtractVolumePatches<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ExtractVolumePatches";
    private Output<T> patches;

    public ExtractVolumePatches(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.patches = operation.output(outputIdx++);
    }

    public static <T extends TNumber> ExtractVolumePatches<T> create(Scope scope, Operand<T> input, List<Long> ksizes, List<Long> strides, String padding) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        long[] ksizesArray = new long[ksizes.size()];
        for (int i = 0; i < ksizesArray.length; ++i) {
            ksizesArray[i] = ksizes.get(i);
        }
        opBuilder.setAttr("ksizes", ksizesArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        return new ExtractVolumePatches<T>(opBuilder.build());
    }

    public Output<T> patches() {
        return this.patches;
    }

    @Override
    public Output<T> asOutput() {
        return this.patches;
    }

    @OpInputsMetadata(outputsClass=ExtractVolumePatches.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<ExtractVolumePatches<T>> {
        public final Operand<T> input;
        public final long[] ksizes;
        public final long[] strides;
        public final DataType T;
        public final String padding;

        public Inputs(GraphOperation op) {
            super(new ExtractVolumePatches(op), op, Arrays.asList("ksizes", "strides", "T", "padding"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.ksizes = op.attributes().getAttrIntList("ksizes");
            this.strides = op.attributes().getAttrIntList("strides");
            this.T = op.attributes().getAttrType("T");
            this.padding = op.attributes().getAttrString("padding");
        }
    }
}

